/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.ImageHeapWalker;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.hub.LayoutEncoding;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

abstract class MemoryWalkerAccessBase
implements MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> {
    private final String regionName;
    private final boolean containsReferences;
    private final boolean isWritable;
    private final boolean hasHugeObjects;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    MemoryWalkerAccessBase(String regionName, boolean containsReferences, boolean isWritable, boolean hasHugeObjects) {
        this.regionName = regionName;
        this.containsReferences = containsReferences;
        this.isWritable = isWritable;
        this.hasHugeObjects = hasHugeObjects;
    }

    @Override
    public UnsignedWord getStart(ImageHeapInfo info) {
        return Word.objectToUntrackedPointer((Object)this.getFirstObject(info));
    }

    @Override
    public UnsignedWord getSize(ImageHeapInfo info) {
        Word firstStart = Word.objectToUntrackedPointer((Object)this.getFirstObject(info));
        if (firstStart.isNull()) {
            return (UnsignedWord)WordFactory.zero();
        }
        Pointer lastEnd = LayoutEncoding.getObjectEnd(this.getLastObject(info));
        return lastEnd.subtract((UnsignedWord)firstStart);
    }

    @Override
    public String getRegionName(ImageHeapInfo region) {
        return this.regionName;
    }

    @Override
    public boolean containsReferences(ImageHeapInfo region) {
        return this.containsReferences;
    }

    @Override
    public boolean isWritable(ImageHeapInfo region) {
        return this.isWritable;
    }

    @Override
    @AlwaysInline(value="GC performance")
    public final boolean visitObjects(ImageHeapInfo region, ObjectVisitor visitor) {
        boolean alignedChunks = !this.hasHugeObjects;
        return ImageHeapWalker.walkPartitionInline(this.getFirstObject(region), this.getLastObject(region), visitor, alignedChunks);
    }

    protected abstract Object getFirstObject(ImageHeapInfo var1);

    protected abstract Object getLastObject(ImageHeapInfo var1);
}

