/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.svm.hosted.annotation.AnnotationArrayValue;
import com.oracle.svm.hosted.annotation.AnnotationClassValue;
import com.oracle.svm.hosted.annotation.AnnotationEnumValue;
import com.oracle.svm.hosted.annotation.AnnotationPrimitiveValue;
import com.oracle.svm.hosted.annotation.AnnotationStringValue;
import com.oracle.svm.hosted.annotation.AnnotationValue;
import java.lang.annotation.Annotation;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import jdk.internal.reflect.ConstantPool;
import jdk.vm.ci.meta.JavaConstant;

public abstract class AnnotationMemberValue {
    static AnnotationMemberValue extract(ByteBuffer buf, ConstantPool cp, Class<?> container, boolean skip) {
        char tag = (char)buf.get();
        switch (tag) {
            case 'e': {
                return AnnotationEnumValue.extract(buf, cp, container, skip);
            }
            case 'c': {
                return AnnotationClassValue.extract(buf, cp, container, skip);
            }
            case 's': {
                return AnnotationStringValue.extract(buf, cp, skip);
            }
            case '@': {
                return AnnotationValue.extract(buf, cp, container, true, skip);
            }
            case '[': {
                return AnnotationArrayValue.extract(buf, cp, container, skip);
            }
        }
        return AnnotationPrimitiveValue.extract(buf, cp, tag, skip);
    }

    static AnnotationMemberValue from(Class<?> type, Object value) {
        if (type.isAnnotation()) {
            return new AnnotationValue((Annotation)value);
        }
        if (type.isEnum()) {
            return new AnnotationEnumValue((Enum)value);
        }
        if (type == Class.class) {
            return new AnnotationClassValue((Class)value);
        }
        if (type == String.class) {
            return new AnnotationStringValue((String)value);
        }
        if (type.isArray()) {
            return new AnnotationArrayValue(type.getComponentType(), (Object[])value);
        }
        return new AnnotationPrimitiveValue(type, value);
    }

    public List<Class<?>> getTypes() {
        return Collections.emptyList();
    }

    public List<String> getStrings() {
        return Collections.emptyList();
    }

    public List<JavaConstant> getExceptionProxies() {
        return Collections.emptyList();
    }

    public abstract char getTag();

    abstract Object get(Class<?> var1);
}

