/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.Truffle;
import java.lang.module.ModuleDescriptor;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

final class ModuleUtils {
    ModuleUtils() {
    }

    static void exportTo(Module clientModule) {
        if (!ModuleUtils.isExportedTo(clientModule)) {
            ModuleUtils.exportFromTo(clientModule);
        }
    }

    static void exportToUnnamedModuleOf(ClassLoader loader) {
        ModuleUtils.exportTo(loader.getUnnamedModule());
    }

    static void exportTransitivelyTo(Module clientModule) {
        if (ModuleUtils.isExportedTo(clientModule)) {
            return;
        }
        ModuleLayer layer = clientModule.getLayer();
        Module truffleModule = Truffle.class.getModule();
        HashSet<Module> targetModules = new HashSet<Module>();
        ArrayDeque<Module> todo = new ArrayDeque<Module>();
        HashSet<Module> visited = new HashSet<Module>();
        todo.add(clientModule);
        HashMap serviceDictionary = null;
        while (!todo.isEmpty()) {
            Module module = (Module)todo.removeFirst();
            if (!visited.add(module) || !Objects.equals(module.getLayer(), layer) || !ModuleUtils.readsTruffleModule(truffleModule, module)) continue;
            targetModules.add(module);
            ModuleDescriptor descriptor = module.getDescriptor();
            if (descriptor == null || descriptor.isAutomatic()) continue;
            for (ModuleDescriptor.Requires requires : descriptor.requires()) {
                Module requiredModule = ModuleUtils.findModule(layer, requires);
                if (requiredModule == null) continue;
                todo.add(requiredModule);
            }
            Set<String> usedServices = descriptor.uses();
            if (usedServices.isEmpty()) continue;
            if (serviceDictionary == null) {
                serviceDictionary = new HashMap();
                for (Module m : layer.modules()) {
                    if (!ModuleUtils.readsTruffleModule(truffleModule, m)) continue;
                    for (ModuleDescriptor.Provides provides : m.getDescriptor().provides()) {
                        serviceDictionary.computeIfAbsent(provides.service(), k -> new HashSet()).add(m);
                    }
                }
            }
            for (String service : usedServices) {
                todo.addAll(serviceDictionary.getOrDefault(service, Set.of()));
            }
        }
        targetModules.forEach(ModuleUtils::exportFromTo);
    }

    private static boolean readsTruffleModule(Module truffleModule, Module otherModule) {
        return otherModule != truffleModule && otherModule.canRead(truffleModule);
    }

    private static Module findModule(ModuleLayer layer, ModuleDescriptor.Requires requires) {
        Optional<Module> moduleOrNull = layer.findModule(requires.name());
        if (moduleOrNull.isPresent()) {
            return moduleOrNull.get();
        }
        if (requires.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.STATIC)) {
            return null;
        }
        throw new AssertionError((Object)String.format("A non-optional module %s not found in the module layer %s.", requires.name(), layer));
    }

    private static boolean isExportedTo(Module clientModule) {
        Module truffleModule = Truffle.class.getModule();
        for (String pack : truffleModule.getPackages()) {
            if (truffleModule.isExported(pack, clientModule)) continue;
            return false;
        }
        return true;
    }

    private static void exportFromTo(Module clientModule) {
        Module truffleModule = Truffle.class.getModule();
        if (truffleModule != clientModule) {
            Set<String> packages = truffleModule.getPackages();
            for (String pkg : packages) {
                boolean exported = truffleModule.isExported(pkg, clientModule);
                if (exported) continue;
                truffleModule.addExports(pkg, clientModule);
            }
        }
    }
}

