/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.polyglot.enterprise.HSPolyglotObject;
import java.io.PrintStream;
import java.util.TooManyListenersException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.LogRecord;
import org.graalvm.jniutils.JNI;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

abstract class HSLogHandler
extends AbstractPolyglotImpl.LogHandler {
    final HSPolyglotObject hostHandler;
    private final ReadWriteLock lock;
    private boolean disposed;

    HSLogHandler(HSPolyglotObject hSPolyglotObject) {
        try {
            this.hostHandler = hSPolyglotObject;
            this.lock = new ReentrantReadWriteLock();
            hSPolyglotObject.addTearDownListener(new HSPolyglotObject.TearDownListener(){

                @Override
                public void beforeTearDown(JNI.JNIEnv jNIEnv) {
                    HSLogHandler.this.lock.writeLock().lock();
                    try {
                        HSLogHandler.this.disposed = true;
                    }
                    finally {
                        HSLogHandler.this.lock.writeLock().unlock();
                    }
                }

                @Override
                public void afterTearDown(JNI.JNIEnv jNIEnv) {
                }
            });
        }
        catch (TooManyListenersException tooManyListenersException) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)tooManyListenersException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void publish(LogRecord logRecord) {
        this.lock.readLock().lock();
        try {
            if (!this.disposed) {
                try {
                    this.publishImpl(logRecord);
                }
                catch (StackOverflowError stackOverflowError) {
                    PrintStream printStream = System.err;
                    printStream.printf("[engine] Failed to publish log record: %s. Insufficient stack space to perform a host call.%n", logRecord.getMessage());
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    abstract void publishImpl(LogRecord var1);

    public final void flush() {
        this.lock.readLock().lock();
        try {
            if (!this.disposed) {
                this.flushImpl();
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    abstract void flushImpl();

    public final void close() {
    }
}

