/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import groovy.lang.GroovyClassLoader;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.DefaultGrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.spring.GrailsRuntimeConfigurator;
import org.codehaus.groovy.grails.scaffolding.GrailsTemplateGenerator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.mock.web.MockServletContext;

public class GenerateUtils {
    private static Log LOG = LogFactory.getLog(GenerateUtils.class);
    private static final String VIEWS = "view";
    private static final String CONTROLLER = "controller";
    private static final String ALL = "all";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            return;
        }
        String type = args[0];
        String domainClassName = args[1];
        ClassPathXmlApplicationContext parent = new ClassPathXmlApplicationContext("applicationContext.xml");
        DefaultGrailsApplication application = (DefaultGrailsApplication)parent.getBean("grailsApplication", DefaultGrailsApplication.class);
        GrailsDomainClass domainClass = GenerateUtils.findInApplication((GrailsApplication)application, domainClassName);
        if (domainClass == null) {
            GrailsRuntimeConfigurator config = new GrailsRuntimeConfigurator((GrailsApplication)application, (ApplicationContext)parent);
            ConfigurableApplicationContext appCtx = (ConfigurableApplicationContext)config.configure((ServletContext)new MockServletContext());
        }
        if ((domainClass = GenerateUtils.findInApplication((GrailsApplication)application, domainClassName)) == null) {
            LOG.info((Object)("Unable to generate [" + type + "] domain class not found for name [" + domainClassName + "]"));
            System.exit(0);
        }
        try {
            block9: {
                try {
                    GroovyClassLoader gcl = new GroovyClassLoader(Thread.currentThread().getContextClassLoader());
                    GrailsTemplateGenerator generator = (GrailsTemplateGenerator)gcl.parseClass(gcl.getResourceAsStream("org/codehaus/groovy/grails/scaffolding/DefaultGrailsTemplateGenerator.groovy")).newInstance();
                    if (!(CONTROLLER.equals(type) || VIEWS.equals(type) || ALL.equals(type))) {
                        LOG.info((Object)("Grails was unable to generate templates for unsupported type [" + type + "]"));
                        break block9;
                    }
                    if (VIEWS.equals(type) || ALL.equals(type)) {
                        LOG.info((Object)("Generating views for domain class [" + domainClass.getName() + "]"));
                        generator.generateViews(domainClass, ".");
                    }
                    if (!CONTROLLER.equals(type) && !ALL.equals(type)) break block9;
                    LOG.info((Object)("Generating controller for domain class [" + domainClass.getName() + "]"));
                    generator.generateController(domainClass, ".");
                }
                catch (Throwable t) {
                    LOG.info((Object)("Error during code generation: " + t.getMessage()));
                    LOG.error((Object)t.getMessage(), t);
                    Object var9_10 = null;
                    System.exit(0);
                    return;
                }
            }
            Object var9_9 = null;
            System.exit(0);
            return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            System.exit(0);
            throw throwable;
        }
    }

    private static GrailsDomainClass findInApplication(GrailsApplication application, String domainClassName) {
        GrailsDomainClass domainClass = (GrailsDomainClass)application.getArtefact("Domain", domainClassName);
        if (domainClass == null) {
            domainClass = (GrailsDomainClass)application.getArtefact("Domain", domainClassName.substring(0, 1).toUpperCase() + domainClassName.substring(1));
        }
        return domainClass;
    }
}

