/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate;

import groovy.lang.GroovySystem;
import groovy.lang.MetaClassRegistry;
import java.util.Map;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.orm.hibernate.cfg.DefaultGrailsDomainConfiguration;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsDomainConfiguration;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsHibernateUtil;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.metadata.ClassMetadata;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;

public class ConfigurableLocalSessionFactoryBean
extends LocalSessionFactoryBean
implements ApplicationContextAware {
    private ClassLoader classLoader = null;
    private GrailsApplication grailsApplication;
    private Class configClass = DefaultGrailsDomainConfiguration.class;
    private ApplicationContext applicationContext;
    private Class currentSessionContextClass;

    public void setCurrentSessionContextClass(Class currentSessionContextClass) {
        this.currentSessionContextClass = currentSessionContextClass;
    }

    public void setConfigClass(Class configClass) {
        this.configClass = configClass;
    }

    public GrailsApplication getGrailsApplication() {
        return this.grailsApplication;
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    protected Configuration newConfiguration() {
        Object config = BeanUtils.instantiateClass((Class)this.configClass);
        if (config instanceof GrailsDomainConfiguration) {
            GrailsDomainConfiguration grailsConfig = (GrailsDomainConfiguration)config;
            grailsConfig.setGrailsApplication(this.grailsApplication);
        }
        if (this.currentSessionContextClass != null) {
            ((Configuration)config).setProperty("hibernate.current_session_context_class", this.currentSessionContextClass.getName());
            this.setExposeTransactionAwareSessionFactory(false);
        }
        return (Configuration)config;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected SessionFactory newSessionFactory(Configuration config) throws HibernateException {
        SessionFactory sf = super.newSessionFactory(config);
        GrailsApplication application = this.getGrailsApplication();
        if (application != null) {
            GrailsHibernateUtil.configureHibernateDomainClasses(sf, application);
        }
        return sf;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void destroy() throws HibernateException {
        MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
        Map classMetaData = this.getSessionFactory().getAllClassMetadata();
        for (Object o : classMetaData.values()) {
            ClassMetadata classMetadata = (ClassMetadata)o;
            Class mappedClass = classMetadata.getMappedClass(EntityMode.POJO);
            registry.removeMetaClass(mappedClass);
        }
        super.destroy();
    }
}

