/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.cfg;

import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.orm.hibernate.GrailsHibernateDomainClass;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsDomainBinder;
import org.codehaus.groovy.grails.orm.hibernate.cfg.Mapping;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.FetchMode;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Order;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class GrailsHibernateUtil {
    private static final Log LOG = LogFactory.getLog(GrailsHibernateUtil.class);
    public static SimpleTypeConverter converter = new SimpleTypeConverter();
    public static final String ARGUMENT_MAX = "max";
    public static final String ARGUMENT_OFFSET = "offset";
    public static final String ARGUMENT_ORDER = "order";
    public static final String ARGUMENT_SORT = "sort";
    public static final String ORDER_DESC = "desc";
    public static final String ORDER_ASC = "asc";
    public static final String ARGUMENT_FETCH = "fetch";
    public static final String ARGUMENT_IGNORE_CASE = "ignoreCase";
    public static final String ARGUMENT_CACHE = "cache";
    public static final String ARGUMENT_LOCK = "lock";

    public static void configureHibernateDomainClasses(SessionFactory sessionFactory, GrailsApplication application) {
        HashMap hibernateDomainClassMap = new HashMap();
        for (Object o : sessionFactory.getAllClassMetadata().values()) {
            ClassMetadata classMetadata = (ClassMetadata)o;
            GrailsHibernateUtil.configureDomainClass(sessionFactory, application, classMetadata, classMetadata.getMappedClass(EntityMode.POJO), hibernateDomainClassMap);
        }
        GrailsHibernateUtil.configureInheritanceMappings(hibernateDomainClassMap);
    }

    public static void configureInheritanceMappings(Map hibernateDomainClassMap) {
        block0: for (Object o : hibernateDomainClassMap.values()) {
            GrailsDomainClass baseClass = (GrailsDomainClass)o;
            if (baseClass.isRoot()) continue;
            Class superClass = baseClass.getClazz().getSuperclass();
            while (!superClass.equals(Object.class) && !superClass.equals(GroovyObject.class)) {
                GrailsDomainClass gdc = (GrailsDomainClass)hibernateDomainClassMap.get(superClass.getName());
                if (gdc == null || gdc.getSubClasses() == null) {
                    LOG.debug((Object)"did not find superclass names when mapping inheritance....");
                    continue block0;
                }
                gdc.getSubClasses().add(baseClass);
                superClass = superClass.getSuperclass();
            }
        }
    }

    private static void configureDomainClass(SessionFactory sessionFactory, GrailsApplication application, ClassMetadata cmd, Class persistentClass, Map hibernateDomainClassMap) {
        if (!Modifier.isAbstract(persistentClass.getModifiers())) {
            LOG.trace((Object)("Configuring domain class [" + persistentClass + "]"));
            GrailsDomainClass dc = (GrailsDomainClass)application.getArtefact("Domain", persistentClass.getName());
            if (dc == null) {
                GrailsHibernateDomainClass ghdc = new GrailsHibernateDomainClass(persistentClass, sessionFactory, cmd);
                hibernateDomainClassMap.put(persistentClass.getName(), ghdc);
                dc = (GrailsDomainClass)application.addArtefact("Domain", (GrailsClass)ghdc);
            }
        }
    }

    public static void populateArgumentsForCriteria(Class targetClass, Criteria c, Map argMap) {
        int offset;
        Integer maxParam = null;
        Integer offsetParam = null;
        if (argMap.containsKey(ARGUMENT_MAX)) {
            maxParam = (Integer)converter.convertIfNecessary(argMap.get(ARGUMENT_MAX), Integer.class);
        }
        if (argMap.containsKey(ARGUMENT_OFFSET)) {
            offsetParam = (Integer)converter.convertIfNecessary(argMap.get(ARGUMENT_OFFSET), Integer.class);
        }
        String orderParam = (String)argMap.get(ARGUMENT_ORDER);
        Object fetchObj = argMap.get(ARGUMENT_FETCH);
        if (fetchObj instanceof Map) {
            Map fetch = (Map)fetchObj;
            for (Object o : fetch.keySet()) {
                String associationName = (String)o;
                c.setFetchMode(associationName, GrailsHibernateUtil.getFetchMode(fetch.get(associationName)));
            }
        }
        String sort = (String)argMap.get(ARGUMENT_SORT);
        String order = ORDER_DESC.equalsIgnoreCase(orderParam) ? ORDER_DESC : ORDER_ASC;
        int max = maxParam == null ? -1 : maxParam;
        int n = offset = offsetParam == null ? -1 : offsetParam;
        if (max > -1) {
            c.setMaxResults(max);
        }
        if (offset > -1) {
            c.setFirstResult(offset);
        }
        if (GrailsClassUtils.getBooleanFromMap((String)ARGUMENT_CACHE, (Map)argMap)) {
            c.setCacheable(true);
        }
        if (GrailsClassUtils.getBooleanFromMap((String)ARGUMENT_LOCK, (Map)argMap)) {
            c.setLockMode(LockMode.UPGRADE);
        } else if (argMap.get(ARGUMENT_CACHE) == null) {
            GrailsHibernateUtil.cacheCriteriaByMapping(targetClass, c);
        }
        if (sort != null) {
            boolean ignoreCase = true;
            Object caseArg = argMap.get(ARGUMENT_IGNORE_CASE);
            if (caseArg instanceof Boolean) {
                ignoreCase = (Boolean)caseArg;
            }
            if (ORDER_DESC.equals(order)) {
                c.addOrder(ignoreCase ? Order.desc((String)sort).ignoreCase() : Order.desc((String)sort));
            } else {
                c.addOrder(ignoreCase ? Order.asc((String)sort).ignoreCase() : Order.asc((String)sort));
            }
        } else {
            Mapping m = GrailsDomainBinder.getMapping(targetClass);
            if (m != null && !StringUtils.isBlank((String)m.getSort())) {
                if (ORDER_DESC.equalsIgnoreCase(m.getOrder())) {
                    c.addOrder(Order.desc((String)m.getSort()));
                } else {
                    c.addOrder(Order.asc((String)m.getSort()));
                }
            }
        }
    }

    public static void cacheCriteriaByMapping(Class targetClass, Criteria criteria) {
        Mapping m = GrailsDomainBinder.getMapping(targetClass);
        if (m != null && m.getCache() != null && m.getCache().getEnabled()) {
            criteria.setCacheable(true);
        }
    }

    public static void populateArgumentsForCriteria(Criteria c, Map argMap) {
        GrailsHibernateUtil.populateArgumentsForCriteria(null, c, argMap);
    }

    public static FetchMode getFetchMode(Object object) {
        String name;
        String string = name = object != null ? object.toString() : "default";
        if (name.equalsIgnoreCase(FetchMode.JOIN.toString()) || name.equalsIgnoreCase("eager")) {
            return FetchMode.JOIN;
        }
        if (name.equalsIgnoreCase(FetchMode.SELECT.toString()) || name.equalsIgnoreCase("lazy")) {
            return FetchMode.SELECT;
        }
        return FetchMode.DEFAULT;
    }

    public static void setObjectToReadyOnly(Object target, SessionFactory sessionFactory) {
        Session session = sessionFactory.getCurrentSession();
        if (GrailsHibernateUtil.canModifyReadWriteState((org.hibernate.Session)session, target)) {
            if (target instanceof HibernateProxy) {
                target = ((HibernateProxy)target).getHibernateLazyInitializer().getImplementation();
            }
            session.setReadOnly(target, true);
            session.setFlushMode(FlushMode.MANUAL);
        }
    }

    private static boolean canModifyReadWriteState(org.hibernate.Session session, Object target) {
        return session.contains(target) && Hibernate.isInitialized((Object)target);
    }

    public static void setObjectToReadWrite(final Object target, SessionFactory sessionFactory) {
        HibernateTemplate template = new HibernateTemplate(sessionFactory);
        template.setExposeNativeSession(true);
        template.execute(new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                SessionImplementor sessionImpl;
                EntityEntry ee;
                if (GrailsHibernateUtil.canModifyReadWriteState(session, target) && (ee = (sessionImpl = (SessionImplementor)session).getPersistenceContext().getEntry(target)) != null && ee.getStatus() == Status.READ_ONLY) {
                    Object actualTarget = target;
                    if (target instanceof HibernateProxy) {
                        actualTarget = ((HibernateProxy)target).getHibernateLazyInitializer().getImplementation();
                    }
                    session.setReadOnly(actualTarget, false);
                    session.setFlushMode(FlushMode.AUTO);
                    GrailsHibernateUtil.incrementVersion(target);
                }
                return null;
            }
        });
    }

    public static void incrementVersion(Object target) {
        Object version;
        MetaClass metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(target.getClass());
        if (metaClass.hasProperty(target, "version") != null && (version = metaClass.getProperty(target, "version")) instanceof Long) {
            Long newVersion = (Long)version + 1L;
            metaClass.setProperty(target, "version", (Object)newVersion);
        }
    }

    public static Object unwrapProxy(HibernateProxy proxy) {
        LazyInitializer lazyInitializer = proxy.getHibernateLazyInitializer();
        if (lazyInitializer.isUninitialized()) {
            lazyInitializer.initialize();
        }
        return lazyInitializer.getImplementation();
    }
}

