/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.cfg;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ApplicationHolder;
import org.codehaus.groovy.grails.commons.ConfigurationHolder;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.type.NullableType;
import org.hibernate.type.TypeFactory;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityEnumType
implements UserType,
ParameterizedType,
Serializable {
    private static final Log LOG = LogFactory.getLog(IdentityEnumType.class);
    public static final String ENUM_ID_ACCESSOR = "getId";
    public static final String PARAM_ENUM_CLASS = "enumClass";
    private static final Map<Class<? extends Enum>, BidiEnumMap> ENUM_MAPPINGS = new HashMap<Class<? extends Enum>, BidiEnumMap>();
    private Class<? extends Enum> enumClass;
    private BidiEnumMap bidiMap;
    private NullableType type;
    private int[] sqlTypes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BidiEnumMap getBidiEnumMap(Class<? extends Enum> cls) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        BidiEnumMap m = ENUM_MAPPINGS.get(cls);
        if (m == null) {
            Map<Class<? extends Enum>, BidiEnumMap> map = ENUM_MAPPINGS;
            synchronized (map) {
                if (!ENUM_MAPPINGS.containsKey(cls)) {
                    m = new BidiEnumMap(cls);
                    ENUM_MAPPINGS.put(cls, m);
                } else {
                    m = ENUM_MAPPINGS.get(cls);
                }
            }
        }
        return m;
    }

    public static boolean isEnabled() {
        Object disableConfigOption = ConfigurationHolder.getFlatConfig().get("grails.orm.enum.id.mapping");
        return disableConfigOption == null || !Boolean.FALSE.equals(disableConfigOption);
    }

    public static boolean supports(Class enumClass) {
        if (!IdentityEnumType.isEnabled()) {
            return false;
        }
        if (GrailsClassUtils.isJdk5Enum((Class)enumClass)) {
            try {
                Method idAccessor = enumClass.getMethod(ENUM_ID_ACCESSOR, new Class[0]);
                int mods = idAccessor.getModifiers();
                if (Modifier.isPublic(mods) && !Modifier.isStatic(mods)) {
                    Class<?> returnType = idAccessor.getReturnType();
                    return returnType != null && TypeFactory.basic((String)returnType.getName()) instanceof NullableType;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return false;
    }

    public void setParameterValues(Properties properties) {
        try {
            this.enumClass = ApplicationHolder.getApplication().getClassLoader().loadClass((String)properties.get(PARAM_ENUM_CLASS));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Building ID-mapping for Enum Class %s", this.enumClass.getName()));
            }
            this.bidiMap = IdentityEnumType.getBidiEnumMap(this.enumClass);
            this.type = (NullableType)TypeFactory.basic((String)this.bidiMap.keyType.getName());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Mapped Basic Type is %s", this.type));
            }
            this.sqlTypes = new int[]{this.type.sqlType()};
        }
        catch (Exception e) {
            throw new MappingException("Error mapping Enum Class using IdentifierEnumType", (Throwable)e);
        }
    }

    public int[] sqlTypes() {
        return this.sqlTypes;
    }

    public Class returnedClass() {
        return this.enumClass;
    }

    public boolean equals(Object o1, Object o2) throws HibernateException {
        return o1 == o2;
    }

    public int hashCode(Object o) throws HibernateException {
        return o.hashCode();
    }

    public Object nullSafeGet(ResultSet resultSet, String[] names, Object owner) throws HibernateException, SQLException {
        Object id = this.type.get(resultSet, names[0]);
        if (!resultSet.wasNull() && id != null) {
            return this.bidiMap.getEnumValue(id);
        }
        return null;
    }

    public void nullSafeSet(PreparedStatement pstmt, Object value, int idx) throws HibernateException, SQLException {
        if (value == null) {
            pstmt.setNull(idx, this.sqlTypes[0]);
        } else {
            this.type.set(pstmt, this.bidiMap.getKey(value), idx);
        }
    }

    public Object deepCopy(Object o) throws HibernateException {
        return o;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object o) throws HibernateException {
        return (Serializable)o;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object orig, Object target, Object owner) throws HibernateException {
        return orig;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BidiEnumMap
    implements Serializable {
        private final Map enumToKey;
        private final Map keytoEnum;
        private Class keyType;

        private BidiEnumMap(Class<? extends Enum> enumClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            Object[] values;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Building Bidirectional Enum Map...", new Object[0]));
            }
            EnumMap enumToKey = new EnumMap(enumClass);
            HashMap<Object, Object> keytoEnum = new HashMap<Object, Object>();
            Method idAccessor = enumClass.getMethod(IdentityEnumType.ENUM_ID_ACCESSOR, new Class[0]);
            this.keyType = idAccessor.getReturnType();
            Method valuesAccessor = enumClass.getMethod("values", new Class[0]);
            for (Object value : values = (Object[])valuesAccessor.invoke(enumClass, new Object[0])) {
                Object id = idAccessor.invoke(value, new Object[0]);
                enumToKey.put(value, id);
                if (keytoEnum.containsKey(id)) {
                    LOG.warn((Object)String.format("Duplicate Enum ID '%s' detected for Enum %s!", id, enumClass.getName()));
                }
                keytoEnum.put(id, value);
            }
            this.enumToKey = Collections.unmodifiableMap(enumToKey);
            this.keytoEnum = Collections.unmodifiableMap(keytoEnum);
        }

        public Object getEnumValue(Object id) {
            return this.keytoEnum.get(id);
        }

        public Object getKey(Object enumValue) {
            return this.enumToKey.get(enumValue);
        }
    }
}

