/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.metaclass;

import groovy.lang.GString;
import groovy.lang.MissingMethodException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.groovy.grails.orm.hibernate.exceptions.GrailsQueryException;
import org.codehaus.groovy.grails.orm.hibernate.metaclass.AbstractStaticPersistentMethod;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.HibernateCallback;

public class ExecuteQueryPersistentMethod
extends AbstractStaticPersistentMethod {
    private static final String METHOD_SIGNATURE = "executeQuery";
    private static final Pattern METHOD_PATTERN = Pattern.compile("^executeQuery$");

    public ExecuteQueryPersistentMethod(SessionFactory sessionFactory, ClassLoader classLoader) {
        super(sessionFactory, classLoader, METHOD_PATTERN);
    }

    protected Object doInvokeInternal(Class clazz, String methodName, Object[] arguments) {
        this.checkMethodSignature(clazz, methodName, arguments);
        final String query = arguments[0].toString();
        final Map paginateParams = this.extractPaginateParams(arguments);
        final List positionalParams = this.extractPositionalParams(arguments);
        final Map namedParams = this.extractNamedParams(arguments);
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(query);
                if (paginateParams.containsKey("max")) {
                    q.setMaxResults(((Number)paginateParams.get("max")).intValue());
                }
                if (paginateParams.containsKey("offset")) {
                    q.setFirstResult(((Number)paginateParams.remove("offset")).intValue());
                }
                int index = 0;
                for (Object e : positionalParams) {
                    q.setParameter(index, e);
                    ++index;
                }
                for (Map.Entry entry : namedParams.entrySet()) {
                    if (!(entry.getKey() instanceof String)) {
                        throw new GrailsQueryException("Named parameter's name must be of type String");
                    }
                    String parameterName = (String)entry.getKey();
                    Object parameterValue = entry.getValue();
                    if (Collection.class.isAssignableFrom(parameterValue.getClass())) {
                        q.setParameterList(parameterName, (Collection)parameterValue);
                        continue;
                    }
                    if (parameterValue.getClass().isArray()) {
                        q.setParameterList(parameterName, (Object[])parameterValue);
                        continue;
                    }
                    if (parameterValue instanceof GString) {
                        q.setParameter(parameterName, (Object)parameterValue.toString());
                        continue;
                    }
                    q.setParameter(parameterName, parameterValue);
                }
                return q.list();
            }
        });
    }

    private void checkMethodSignature(Class clazz, String methodName, Object[] arguments) {
        boolean valid = true;
        if (arguments.length < 1) {
            valid = false;
        } else if (arguments.length == 3 && !(arguments[2] instanceof Map)) {
            valid = false;
        } else if (arguments.length > 3) {
            valid = false;
        }
        if (!valid) {
            throw new MissingMethodException(METHOD_SIGNATURE, clazz, arguments);
        }
    }

    private Map extractPaginateParams(Object[] arguments) {
        HashMap result = new HashMap();
        int paginateParamsIndex = 0;
        if (arguments.length == 2 && arguments[1] instanceof Map) {
            paginateParamsIndex = 1;
        } else if (arguments.length == 3) {
            paginateParamsIndex = 2;
        }
        if (paginateParamsIndex > 0) {
            Map sourceMap = (Map)arguments[paginateParamsIndex];
            if (sourceMap.containsKey("max")) {
                result.put("max", sourceMap.get("max"));
            }
            if (sourceMap.containsKey("offset")) {
                result.put("offset", sourceMap.get("offset"));
            }
        }
        return result;
    }

    private List extractPositionalParams(Object[] arguments) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (arguments.length < 2 || arguments[1] instanceof Map) {
            return result;
        }
        if (arguments[1] instanceof Collection) {
            result.addAll((Collection)arguments[1]);
        } else if (arguments[1].getClass().isArray()) {
            result.addAll(Arrays.asList((Object[])arguments[1]));
        } else {
            result.add(arguments[1]);
        }
        return result;
    }

    private Map extractNamedParams(Object[] arguments) {
        HashMap result = new HashMap();
        if (arguments.length < 2 || !(arguments[1] instanceof Map)) {
            return result;
        }
        result.putAll((Map)arguments[1]);
        result.remove("max");
        result.remove("offset");
        return result;
    }
}

