/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.metaclass;

import java.sql.SQLException;
import java.util.regex.Pattern;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.orm.hibernate.metaclass.AbstractSavePersistentMethod;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class SavePersistentMethod
extends AbstractSavePersistentMethod {
    public static final String METHOD_SIGNATURE = "save";
    public static final Pattern METHOD_PATTERN = Pattern.compile("^save$");

    public SavePersistentMethod(SessionFactory sessionFactory, ClassLoader classLoader, GrailsApplication application) {
        super(METHOD_PATTERN, sessionFactory, classLoader, application);
    }

    protected Object performSave(final Object target, final boolean flush) {
        HibernateTemplate ht = this.getHibernateTemplate();
        return ht.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.saveOrUpdate(target);
                if (flush) {
                    SavePersistentMethod.this.getHibernateTemplate().flush();
                }
                return target;
            }
        });
    }

    protected Object performInsert(final Object target, final boolean shouldFlush) {
        HibernateTemplate ht = this.getHibernateTemplate();
        return ht.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.save(target);
                if (shouldFlush) {
                    SavePersistentMethod.this.getHibernateTemplate().flush();
                }
                return target;
            }
        });
    }
}

