/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.metaclass;

import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.orm.hibernate.metaclass.AbstractDynamicPersistentMethod;
import org.codehaus.groovy.grails.validation.CascadingValidator;
import org.hibernate.SessionFactory;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;

public class ValidatePersistentMethod
extends AbstractDynamicPersistentMethod {
    public static final String METHOD_SIGNATURE = "validate";
    public static final Pattern METHOD_PATTERN = Pattern.compile("^validate$");
    private GrailsApplication application;
    private static final String ARGUMENT_DEEP_VALIDATE = "deepValidate";
    private static final String ARGUMENT_EVICT = "evict";
    private static final String ERRORS_PROPERTY = "errors";

    public ValidatePersistentMethod(SessionFactory sessionFactory, ClassLoader classLoader, GrailsApplication application) {
        super(METHOD_PATTERN, sessionFactory, classLoader);
        if (application == null) {
            throw new IllegalArgumentException("Constructor argument 'application' cannot be null");
        }
        this.application = application;
    }

    protected Object doInvokeInternal(Object target, Object[] arguments) {
        MetaClass mc = GroovySystem.getMetaClassRegistry().getMetaClass(target.getClass());
        BeanPropertyBindingResult errors = new BeanPropertyBindingResult(target, target.getClass().getName());
        mc.setProperty(target, ERRORS_PROPERTY, (Object)errors);
        GrailsDomainClass domainClass = (GrailsDomainClass)this.application.getArtefact("Domain", target.getClass().getName());
        Validator validator = null;
        if (domainClass != null) {
            validator = domainClass.getValidator();
        }
        Boolean valid = Boolean.TRUE;
        if (validator != null) {
            boolean evict = false;
            boolean deepValidate = true;
            HashSet validatedFields = null;
            if (arguments.length > 0) {
                if (arguments[0] instanceof Boolean) {
                    evict = (Boolean)arguments[0];
                }
                if (arguments[0] instanceof Map) {
                    Map argsMap = (Map)arguments[0];
                    if (argsMap.containsKey(ARGUMENT_DEEP_VALIDATE)) {
                        deepValidate = GrailsClassUtils.getBooleanFromMap((String)ARGUMENT_DEEP_VALIDATE, (Map)argsMap);
                    }
                    evict = GrailsClassUtils.getBooleanFromMap((String)ARGUMENT_EVICT, (Map)argsMap);
                }
                if (arguments[0] instanceof List) {
                    validatedFields = new HashSet((List)arguments[0]);
                }
            }
            if (deepValidate && validator instanceof CascadingValidator) {
                ((CascadingValidator)validator).validate(target, (Errors)errors, deepValidate);
            } else {
                validator.validate(target, (Errors)errors);
            }
            int oldErrorCount = errors.getErrorCount();
            errors = this.filterErrors((Errors)errors, validatedFields, target);
            if (errors.hasErrors()) {
                valid = Boolean.FALSE;
                if (evict) {
                    if (this.getHibernateTemplate().contains(target)) {
                        this.getHibernateTemplate().evict(target);
                    }
                } else {
                    this.setObjectToReadOnly(target);
                }
            } else {
                this.setObjectToReadWrite(target);
            }
            if (errors.getErrorCount() != oldErrorCount) {
                MetaClass metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(target.getClass());
                metaClass.setProperty(target, ERRORS_PROPERTY, (Object)errors);
            }
        }
        return valid;
    }

    private Errors filterErrors(Errors errors, Set validatedFields, Object target) {
        if (validatedFields == null) {
            return errors;
        }
        BeanPropertyBindingResult result = new BeanPropertyBindingResult(target, target.getClass().getName());
        List allErrors = errors.getAllErrors();
        for (int i = 0; i < allErrors.size(); ++i) {
            FieldError fieldError;
            ObjectError error = (ObjectError)allErrors.get(i);
            if (error instanceof FieldError && !validatedFields.contains((fieldError = (FieldError)error).getField())) continue;
            result.addError(error);
        }
        return result;
    }
}

