/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.support;

import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.orm.hibernate.exceptions.CouldNotDetermineHibernateDialectException;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.support.JdbcUtils;

public class HibernateDialectDetectorFactoryBean
implements FactoryBean,
InitializingBean {
    private DataSource dataSource = null;
    private Properties vendorNameDialectMappings = null;
    private String hibernateDialectClassName = null;
    private Dialect hibernateDialect;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setVendorNameDialectMappings(Properties mappings) {
        this.vendorNameDialectMappings = mappings;
    }

    public Object getObject() throws Exception {
        return this.hibernateDialectClassName;
    }

    public Class getObjectType() {
        return String.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.dataSource == null) {
            throw new IllegalStateException("Data source is not set!");
        }
        if (this.vendorNameDialectMappings == null) {
            throw new IllegalStateException("Vendor name/dialect mappings are not set!");
        }
        String dbName = (String)JdbcUtils.extractDatabaseMetaData((DataSource)this.dataSource, (String)"getDatabaseProductName");
        Integer majorVersion = (Integer)JdbcUtils.extractDatabaseMetaData((DataSource)this.dataSource, (String)"getDatabaseMajorVersion");
        try {
            this.hibernateDialect = DialectFactory.determineDialect((String)dbName, (int)majorVersion);
            this.hibernateDialectClassName = this.hibernateDialect.getClass().getName();
        }
        catch (HibernateException e) {
            this.hibernateDialectClassName = this.vendorNameDialectMappings.getProperty(dbName);
        }
        if (StringUtils.isBlank((String)this.hibernateDialectClassName)) {
            throw new CouldNotDetermineHibernateDialectException("Could not determine Hibernate dialect for database name [" + dbName + "]!");
        }
    }
}

