/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Locale;
import org.graphstream.graph.CompoundAttribute;
import org.graphstream.stream.file.FileSinkBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSinkDGS
extends FileSinkBase {
    protected PrintWriter out;
    protected String graphName = "";

    @Override
    protected void outputHeader() throws IOException {
        this.out = (PrintWriter)this.output;
        this.out.printf("DGS004%n", new Object[0]);
        if (this.graphName.length() <= 0) {
            this.out.printf("null 0 0%n", new Object[0]);
        } else {
            this.out.printf("\"%s\" 0 0%n", this.formatStringForQuoting(this.graphName));
        }
    }

    @Override
    protected void outputEndOfFile() throws IOException {
    }

    @Override
    public void edgeAttributeAdded(String graphId, long timeId, String edgeId, String attribute, Object value) {
        this.edgeAttributeChanged(graphId, timeId, edgeId, attribute, null, value);
    }

    @Override
    public void edgeAttributeChanged(String graphId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        this.out.printf("ce \"%s\" %s%n", this.formatStringForQuoting(edgeId), this.attributeString(attribute, newValue, false));
    }

    @Override
    public void edgeAttributeRemoved(String graphId, long timeId, String edgeId, String attribute) {
        this.out.printf("ce \"%s\" %s%n", this.formatStringForQuoting(edgeId), this.attributeString(attribute, null, true));
    }

    @Override
    public void graphAttributeAdded(String graphId, long timeId, String attribute, Object value) {
        this.graphAttributeChanged(graphId, timeId, attribute, null, value);
    }

    @Override
    public void graphAttributeChanged(String graphId, long timeId, String attribute, Object oldValue, Object newValue) {
        this.out.printf("cg %s%n", this.attributeString(attribute, newValue, false));
    }

    @Override
    public void graphAttributeRemoved(String graphId, long timeId, String attribute) {
        this.out.printf("cg %s%n", this.attributeString(attribute, null, true));
    }

    @Override
    public void nodeAttributeAdded(String graphId, long timeId, String nodeId, String attribute, Object value) {
        this.nodeAttributeChanged(graphId, timeId, nodeId, attribute, null, value);
    }

    @Override
    public void nodeAttributeChanged(String graphId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        this.out.printf("cn \"%s\" %s%n", this.formatStringForQuoting(nodeId), this.attributeString(attribute, newValue, false));
    }

    @Override
    public void nodeAttributeRemoved(String graphId, long timeId, String nodeId, String attribute) {
        this.out.printf("cn \"%s\" %s%n", this.formatStringForQuoting(nodeId), this.attributeString(attribute, null, true));
    }

    @Override
    public void edgeAdded(String graphId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        edgeId = this.formatStringForQuoting(edgeId);
        fromNodeId = this.formatStringForQuoting(fromNodeId);
        toNodeId = this.formatStringForQuoting(toNodeId);
        this.out.printf("ae \"%s\" \"%s\" %s \"%s\"%n", edgeId, fromNodeId, directed ? ">" : "", toNodeId);
    }

    @Override
    public void edgeRemoved(String graphId, long timeId, String edgeId) {
        this.out.printf("de \"%s\"%n", this.formatStringForQuoting(edgeId));
    }

    @Override
    public void graphCleared(String graphId, long timeId) {
        this.out.printf("cl%n", new Object[0]);
    }

    @Override
    public void nodeAdded(String graphId, long timeId, String nodeId) {
        this.out.printf("an \"%s\"%n", this.formatStringForQuoting(nodeId));
    }

    @Override
    public void nodeRemoved(String graphId, long timeId, String nodeId) {
        this.out.printf("dn \"%s\"%n", this.formatStringForQuoting(nodeId));
    }

    @Override
    public void stepBegins(String graphId, long timeId, double step) {
        this.out.printf(Locale.US, "st %f%n", step);
    }

    protected String formatStringForQuoting(String str) {
        return str.replaceAll("(^|[^\\\\])\"", "$1\\\\\"");
    }

    protected String attributeString(String key, Object value, boolean remove) {
        if (key == null || key.length() == 0) {
            return null;
        }
        if (remove) {
            return String.format(" -\"%s\"", key);
        }
        if (value != null && value.getClass().isArray()) {
            return String.format(" \"%s\":%s", key, this.arrayString(value));
        }
        return String.format(" \"%s\":%s", key, this.valueString(value));
    }

    protected String arrayString(Object value) {
        if (value != null && value.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            if (Array.getLength(value) == 0) {
                sb.append("\"\"");
            } else {
                sb.append(this.arrayString(Array.get(value, 0)));
            }
            for (int i = 1; i < Array.getLength(value); ++i) {
                sb.append(String.format(",%s", this.arrayString(Array.get(value, i))));
            }
            sb.append("}");
            return sb.toString();
        }
        return this.valueString(value);
    }

    protected String valueString(Object value) {
        if (value == null) {
            return "\"\"";
        }
        if (value instanceof CharSequence) {
            if (value instanceof String) {
                return String.format("\"%s\"", this.formatStringForQuoting((String)value));
            }
            return String.format("\"%s\"", (CharSequence)value);
        }
        if (value instanceof Number) {
            Number nval = (Number)value;
            if (value instanceof Integer || value instanceof Short || value instanceof Byte || value instanceof Long) {
                return String.format(Locale.US, "%d", nval.longValue());
            }
            return String.format(Locale.US, "%f", nval.doubleValue());
        }
        if (value instanceof Boolean) {
            return String.format(Locale.US, "%b", (Boolean)value);
        }
        if (value instanceof Character) {
            return String.format("\"%c\"", Character.valueOf(((Character)value).charValue()));
        }
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            int n = array.length;
            StringBuffer sb = new StringBuffer();
            if (array.length > 0) {
                sb.append(this.valueString(array[0]));
            }
            for (int i = 1; i < n; ++i) {
                sb.append(",");
                sb.append(this.valueString(array[i]));
            }
            return sb.toString();
        }
        if (value instanceof HashMap || value instanceof CompoundAttribute) {
            HashMap<?, ?> hash = value instanceof CompoundAttribute ? ((CompoundAttribute)value).toHashMap() : (HashMap<?, ?>)value;
            return this.hashToString(hash);
        }
        if (value instanceof Color) {
            Color c = (Color)value;
            return String.format("#%02X%02X%02X%02X", c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
        }
        return String.format("\"%s\"", value.toString());
    }

    protected String hashToString(HashMap<?, ?> hash) {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        for (Object key : hash.keySet()) {
            sb.append(this.attributeString(key.toString(), hash.get(key), false));
            sb.append(",");
        }
        sb.append(']');
        return sb.toString();
    }
}

