/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.AdjacencyListGraph;
import org.graphstream.stream.file.FileSinkBase;

public class FileSinkGEXF
extends FileSinkBase {
    XMLStreamWriter stream;
    boolean smart = true;
    int depth = 0;
    int currentAttributeIndex = 0;

    protected void outputEndOfFile() throws IOException {
        try {
            this.endElement(this.stream, false);
            this.stream.writeEndDocument();
            this.stream.flush();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    protected void outputHeader() throws IOException {
        Calendar cal = Calendar.getInstance();
        Date date = cal.getTime();
        DateFormat df = DateFormat.getDateTimeInstance(3, 3);
        try {
            this.stream = XMLOutputFactory.newFactory().createXMLStreamWriter(this.output);
            this.stream.writeStartDocument("UTF-8", "1.0");
            this.startElement(this.stream, "gexf");
            this.stream.writeAttribute("xmlns", "http://www.gexf.net/1.2draft");
            this.stream.writeAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.stream.writeAttribute("xsi:schemaLocation", "http://www.gexf.net/1.2draft http://www.gexf.net/1.2draft/gexf.xsd");
            this.stream.writeAttribute("version", "1.2");
            this.startElement(this.stream, "meta");
            this.stream.writeAttribute("lastmodifieddate", df.format(date));
            this.startElement(this.stream, "creator");
            this.stream.writeCharacters("GraphStream - " + this.getClass().getName());
            this.endElement(this.stream, true);
            this.endElement(this.stream, false);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new IOException(e);
        }
    }

    protected void startElement(XMLStreamWriter stream, String name) throws XMLStreamException {
        if (this.smart) {
            stream.writeCharacters("\n");
            for (int i = 0; i < this.depth; ++i) {
                stream.writeCharacters("\t");
            }
        }
        stream.writeStartElement(name);
        ++this.depth;
    }

    protected void endElement(XMLStreamWriter stream, boolean leaf) throws XMLStreamException {
        --this.depth;
        if (this.smart && !leaf) {
            stream.writeCharacters("\n");
            for (int i = 0; i < this.depth; ++i) {
                stream.writeCharacters("\t");
            }
        }
        stream.writeEndElement();
    }

    protected void exportGraph(Graph g) {
        GEXFAttributeMap nodeAttributes = new GEXFAttributeMap("node", g);
        GEXFAttributeMap edgeAttributes = new GEXFAttributeMap("edge", g);
        try {
            this.startElement(this.stream, "graph");
            this.stream.writeAttribute("defaultedgetype", "undirected");
            nodeAttributes.export(this.stream);
            edgeAttributes.export(this.stream);
            this.startElement(this.stream, "nodes");
            for (Node n : g.getEachNode()) {
                this.startElement(this.stream, "node");
                this.stream.writeAttribute("id", n.getId());
                if (n.hasAttribute("label")) {
                    this.stream.writeAttribute("label", n.getAttribute("label").toString());
                }
                if (n.getAttributeCount() > 0) {
                    this.startElement(this.stream, "attvalues");
                    for (String key : n.getAttributeKeySet()) {
                        nodeAttributes.push(this.stream, n, key);
                    }
                    this.endElement(this.stream, false);
                }
                this.endElement(this.stream, n.getAttributeCount() == 0);
            }
            this.endElement(this.stream, false);
            this.startElement(this.stream, "edges");
            for (Edge e : g.getEachEdge()) {
                this.startElement(this.stream, "edge");
                this.stream.writeAttribute("id", e.getId());
                this.stream.writeAttribute("source", e.getSourceNode().getId());
                this.stream.writeAttribute("target", e.getTargetNode().getId());
                if (e.getAttributeCount() > 0) {
                    this.startElement(this.stream, "attvalues");
                    for (String key : e.getAttributeKeySet()) {
                        nodeAttributes.push(this.stream, e, key);
                    }
                    this.endElement(this.stream, false);
                }
                this.endElement(this.stream, e.getAttributeCount() == 0);
            }
            this.endElement(this.stream, false);
            this.endElement(this.stream, false);
        }
        catch (XMLStreamException e1) {
            e1.printStackTrace();
        }
    }

    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        throw new UnsupportedOperationException();
    }

    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        throw new UnsupportedOperationException();
    }

    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        throw new UnsupportedOperationException();
    }

    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        throw new UnsupportedOperationException();
    }

    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        throw new UnsupportedOperationException();
    }

    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        throw new UnsupportedOperationException();
    }

    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        throw new UnsupportedOperationException();
    }

    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        throw new UnsupportedOperationException();
    }

    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        throw new UnsupportedOperationException();
    }

    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        throw new UnsupportedOperationException();
    }

    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        throw new UnsupportedOperationException();
    }

    public void graphCleared(String sourceId, long timeId) {
        throw new UnsupportedOperationException();
    }

    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        throw new UnsupportedOperationException();
    }

    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        throw new UnsupportedOperationException();
    }

    public void stepBegins(String sourceId, long timeId, double step) {
        throw new UnsupportedOperationException();
    }

    public static void main(String ... args) throws Exception {
        AdjacencyListGraph g = new AdjacencyListGraph("g");
        g.addNode("A").addAttribute("label", "Node A");
        g.addNode("B").addAttribute("test", 1.0);
        g.addNode("C").addAttribute("test", "Test");
        g.addNode("D").addAttribute("other", true);
        g.addEdge("AB", "A", "B");
        FileSinkGEXF out = new FileSinkGEXF();
        out.writeAll((Graph)g, System.out);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GEXFAttributeMap
    extends HashMap<String, GEXFAttribute> {
        private static final long serialVersionUID = 6176508111522815024L;
        protected String type;

        GEXFAttributeMap(String type, Graph g) {
            this.type = type;
            Collection iterable = type.equals("node") ? g.getNodeSet() : g.getEdgeSet();
            for (Element e : iterable) {
                for (String key : e.getAttributeKeySet()) {
                    Object value = e.getAttribute(key);
                    String id = this.getID(key, value);
                    String attType = "string";
                    if (this.containsKey(id)) continue;
                    if (value instanceof Integer || value instanceof Short) {
                        attType = "integer";
                    } else if (value instanceof Long) {
                        attType = "long";
                    } else if (value instanceof Float) {
                        attType = "float";
                    } else if (value instanceof Double) {
                        attType = "double";
                    } else if (value instanceof Boolean) {
                        attType = "boolean";
                    } else if (value instanceof URL || value instanceof URI) {
                        attType = "anyURI";
                    } else if (value.getClass().isArray() || value instanceof Collection) {
                        attType = "liststring";
                    }
                    this.put(id, new GEXFAttribute(key, attType));
                }
            }
        }

        String getID(String key, Object value) {
            return String.format("%s@%s", key, value.getClass().getName());
        }

        void export(XMLStreamWriter stream) throws XMLStreamException {
            if (this.size() == 0) {
                return;
            }
            FileSinkGEXF.this.startElement(stream, "attributes");
            stream.writeAttribute("class", this.type);
            for (GEXFAttribute a : this.values()) {
                FileSinkGEXF.this.startElement(stream, "attribute");
                stream.writeAttribute("id", Integer.toString(a.index));
                stream.writeAttribute("title", a.key);
                stream.writeAttribute("type", a.type);
                FileSinkGEXF.this.endElement(stream, true);
            }
            FileSinkGEXF.this.endElement(stream, this.size() == 0);
        }

        void push(XMLStreamWriter stream, Element e, String key) throws XMLStreamException {
            String id = this.getID(key, e.getAttribute(key));
            GEXFAttribute a = (GEXFAttribute)this.get(id);
            if (a == null) {
                return;
            }
            FileSinkGEXF.this.startElement(stream, "attvalue");
            stream.writeAttribute("for", Integer.toString(a.index));
            stream.writeAttribute("value", e.getAttribute(key).toString());
            FileSinkGEXF.this.endElement(stream, true);
        }
    }

    class GEXFAttribute {
        int index;
        String key;
        String type;

        GEXFAttribute(String key, String type) {
            this.index = FileSinkGEXF.this.currentAttributeIndex++;
            this.key = key;
            this.type = type;
        }
    }
}

