/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.swingViewer.basicRenderer.shapes;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import org.graphstream.ui.graphicGraph.GraphicEdge;
import org.graphstream.ui.graphicGraph.GraphicNode;
import org.graphstream.ui.graphicGraph.StyleGroup;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.swingViewer.basicRenderer.shapes.Shape;
import org.graphstream.ui.swingViewer.util.GraphMetrics;

public class Arrow
extends Shape {
    protected Color fillColor = Color.BLACK;
    protected Color strokeColor = Color.BLACK;
    protected int lengthGu = 0;
    protected int widthGu = 0;
    protected double x;
    protected double y;
    protected Path2D.Float path = new Path2D.Float();

    public void setArrowLengthGu(int lengthGu) {
        this.lengthGu = lengthGu;
    }

    public void setArrowWidthGu(int widthGu) {
        this.widthGu = widthGu;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public void setStrokeColor(Color color) {
        this.strokeColor = color;
    }

    public void renderFill(Graphics2D g, GraphMetrics metrics) {
        g.setColor(this.fillColor);
        g.fill(this.path);
    }

    public void renderStroke(Graphics2D g, GraphMetrics metrics) {
        g.setColor(this.strokeColor);
        g.draw(this.path);
    }

    protected void setPositionAndShape(GraphicEdge edge, GraphMetrics metrics) {
        this.x = edge.to.x;
        this.y = edge.to.y;
        double vx = this.x - edge.from.x;
        double vy = this.y - edge.from.y;
        double off = this.evalTargetRadius(edge, metrics);
        double d = Math.sqrt(vx * vx + vy * vy);
        this.x -= (vx /= d) * off;
        this.y -= (vy /= d) * off;
        this.setShapeAt(this.x, this.y, vx, vy);
    }

    protected void setShapeAt(double x, double y, double dx, double dy) {
        double dx2 = dy;
        double dy2 = -dx;
        double d2 = Math.sqrt(dx2 * dx2 + dy2 * dy2);
        dx2 /= d2;
        dy2 /= d2;
        this.path.reset();
        this.path.moveTo(x, y);
        this.path.lineTo(x - dx + (dx2 *= (double)this.widthGu), y - dy + (dy2 *= (double)this.widthGu));
        this.path.lineTo(x - dx - dx2, y - dy - dy2);
        this.path.closePath();
    }

    protected double evalTargetRadius(GraphicEdge edge, GraphMetrics metrics) {
        double h;
        GraphicNode target = edge.to;
        StyleGroup group = target.getStyle();
        double w = metrics.lengthToGu(group.getSize(), 0);
        double d = h = group.getSize().size() > 1 ? metrics.lengthToGu(group.getSize(), 1) : w;
        if (w == h) {
            double b = group.getStrokeMode() != StyleConstants.StrokeMode.NONE ? metrics.lengthToGu(group.getStrokeWidth()) : 0.0;
            return w / 2.0 + b;
        }
        return this.evalEllipseRadius(edge, w, h);
    }

    protected double evalEllipseRadius(GraphicEdge edge, double w, double h) {
        double dx = edge.to.x - edge.from.x;
        double dy = edge.to.y - edge.from.y;
        double d = Math.sqrt(dx * dx + (dy *= w / h) * dy);
        double a = dx / d;
        a = Math.acos(a);
        dx = Math.cos(a) * w;
        dy = Math.sin(a) * h;
        return Math.sqrt(dx * dx + dy * dy);
    }
}

