/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.util;

import java.awt.Component;
import java.awt.geom.Point2D;
import javax.swing.JFrame;
import org.graphstream.ui.geom.Point2;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.geom.Vector2;
import org.graphstream.ui.graphicGraph.GraphicEdge;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.GraphicNode;
import org.graphstream.ui.j2dviewer.Camera;
import org.graphstream.ui.j2dviewer.renderer.AreaSkeleton;
import org.graphstream.ui.j2dviewer.renderer.Skeleton$;
import org.graphstream.ui.j2dviewer.renderer.shape.Connector;
import org.graphstream.ui.util.CubicCurve;
import org.graphstream.ui.util.ShapeUtil$;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;

public final class CubicCurve$ {
    public static final CubicCurve$ MODULE$;

    static {
        new CubicCurve$();
    }

    public double eval(double x0, double x1, double x2, double x3, double t) {
        double tt = 1.0 - t;
        return x0 * (tt * tt * tt) + 3.0 * x1 * t * (tt * tt) + 3.0 * x2 * (t * t) * tt + x3 * (t * t * t);
    }

    public Point2 eval(Point2 p0, Point2 p1, Point2 p2, Point2 p3, double t) {
        return new Point2(this.eval(p0.x, p1.x, p2.x, p3.x, t), this.eval(p0.y, p1.y, p2.y, p3.y, t));
    }

    public Point3 eval(Point3 p0, Point3 p1, Point3 p2, Point3 p3, double t) {
        return new Point3(this.eval(p0.x, p1.x, p2.x, p3.x, t), this.eval(p0.y, p1.y, p2.y, p3.y, t), this.eval(p0.z, p1.z, p2.z, p3.z, t));
    }

    public Point2D.Double eval(Point2D.Double p0, Point2D.Double p1, Point2D.Double p2, Point2D.Double p3, double t) {
        return new Point2D.Double(this.eval(p0.x, p1.x, p2.x, p3.x, t), this.eval(p0.y, p1.y, p2.y, p3.y, t));
    }

    public Point2 eval(Point2 p0, Point2 p1, Point2 p2, Point2 p3, double t, Point2 result) {
        result.set(this.eval(p0.x, p1.x, p2.x, p3.x, t), this.eval(p0.y, p1.y, p2.y, p3.y, t));
        return result;
    }

    public Point3 eval(Point3 p0, Point3 p1, Point3 p2, Point3 p3, double t, Point3 result) {
        result.set(this.eval(p0.x, p1.x, p2.x, p3.x, t), this.eval(p0.y, p1.y, p2.y, p3.y, t), this.eval(p0.z, p1.z, p2.z, p3.z, t));
        return result;
    }

    public double derivative(double x0, double x1, double x2, double x3, double t) {
        return (double)3 * (x3 - (double)3 * x2 + (double)3 * x1 - x0) * t * t + (double)2 * ((double)3 * x2 - (double)6 * x1 + (double)3 * x0) * t + ((double)3 * x1 - (double)3 * x0);
    }

    public Point2 derivative(Point2 p0, Point2 p1, Point2 p2, Point2 p3, double t) {
        return new Point2(this.derivative(p0.x, p1.x, p2.x, p3.x, t), this.derivative(p0.y, p1.y, p2.y, p3.y, t));
    }

    public Point3 derivative(Point3 p0, Point3 p1, Point3 p2, Point3 p3, double t) {
        return new Point3(this.derivative(p0.x, p1.x, p2.x, p3.x, t), this.derivative(p0.y, p1.y, p2.y, p3.y, t), this.derivative(p0.z, p1.z, p2.z, p3.z, t));
    }

    public Point2 derivative(Point2 p0, Point2 p1, Point2 p2, Point3 p3, double t, Point2 result) {
        result.set(this.derivative(p0.x, p1.x, p2.x, p3.x, t), this.derivative(p0.y, p1.y, p2.y, p3.y, t));
        return result;
    }

    public Point3 derivative(Point3 p0, Point3 p1, Point3 p2, Point3 p3, double t, Point3 result) {
        result.set(this.derivative(p0.x, p1.x, p2.x, p3.x, t), this.derivative(p0.y, p1.y, p2.y, p3.y, t), this.derivative(p0.z, p1.z, p2.z, p3.z, t));
        return result;
    }

    public Vector2 perpendicular(Point2 p0, Point2 p1, Point2 p2, Point2 p3, double t) {
        return new Vector2(this.derivative(p0.y, p1.y, p2.y, p3.y, t), -this.derivative(p0.x, p1.x, p2.x, p3.x, t));
    }

    public Vector2 perpendicular(Point2 p0, Point2 p1, Point2 p2, Point2 p3, double t, Vector2 result) {
        result.set(this.derivative(p0.y, p1.y, p2.y, p3.y, t), -this.derivative(p0.x, p1.x, p2.x, p3.x, t));
        return result;
    }

    public Point2D.Double perpendicular(Point2D.Double p0, Point2D.Double p1, Point2D.Double p2, Point2D.Double p3, double t) {
        return new Point2D.Double(this.derivative(p0.y, p1.y, p2.y, p3.y, t), -this.derivative(p0.x, p1.x, p2.x, p3.x, t));
    }

    public double approxLengthOfCurveQuickAndDirty(Connector c) {
        return c.fromPos().distance(c.byPos1()) * 0.5 + c.byPos1().distance(c.byPos2()) * (double)0.8f + c.byPos2().distance(c.toPos()) * 0.5;
    }

    public double approxLengthOfCurveQuick(Connector c) {
        Point3 ip0 = this.eval(c.fromPos(), c.byPos1(), c.byPos2(), c.toPos(), (double)0.1f);
        Point3 ip1 = this.eval(c.fromPos(), c.byPos1(), c.byPos2(), c.toPos(), (double)0.3f);
        Point3 ip2 = this.eval(c.fromPos(), c.byPos1(), c.byPos2(), c.toPos(), (double)0.7f);
        Point3 ip3 = this.eval(c.fromPos(), c.byPos1(), c.byPos2(), c.toPos(), (double)0.9f);
        return c.fromPos().distance(ip0) + ip0.distance(ip1) + ip1.distance(ip2) + ip2.distance(ip3) + ip3.distance(c.toPos());
    }

    public double approxLengthOfCurve(Connector c) {
        double inc;
        double i = inc = 0.1;
        double len = 0.0;
        Point3 p0 = c.fromPos();
        while (i < 1.0) {
            Point3 p = this.eval(c.fromPos(), c.byPos1(), c.byPos2(), c.toPos(), i);
            i += inc;
            len += p0.distance(p);
            p0 = p;
        }
        return len += p0.distance(c.toPos());
    }

    public Tuple2<Point2, Point2> approxVectorEnteringCurve(GraphicEdge edge, Connector c, Camera camera) {
        float inc;
        GraphicNode node = edge.to;
        AreaSkeleton info = (AreaSkeleton)node.getAttribute(Skeleton$.MODULE$.attributeName());
        double w = 0.0;
        double h = 0.0;
        if (info == null) {
            w = camera.metrics().lengthToGu(node.getStyle().getSize(), 0);
            h = node.getStyle().getSize().size() > 1 ? camera.metrics().lengthToGu(node.getStyle().getSize(), 1) : w;
        } else {
            w = info.theSize().x;
            h = info.theSize().y;
        }
        boolean searching = true;
        Point3 p0 = c.fromPos();
        Point3 p1 = c.toPos();
        float i = inc = 0.1f;
        while (searching) {
            p1 = this.eval(c.fromPos(), c.byPos1(), c.byPos2(), c.toPos(), (double)i);
            if (ShapeUtil$.MODULE$.isPointIn((GraphicElement)node, p1, w, h)) {
                searching = false;
                continue;
            }
            p0 = p1;
        }
        return new Tuple2((Object)p0, (Object)p1);
    }

    public Tuple2<Point2, Object> approxIntersectionPointOnCurve(GraphicEdge edge, Connector c, Camera camera) {
        return this.approxIntersectionPointOnCurve(edge, c, camera, 7);
    }

    public Tuple2<Point2, Object> approxIntersectionPointOnCurve(GraphicEdge edge, Connector c, Camera camera, int maxDepth) {
        GraphicNode node = edge.to;
        AreaSkeleton info = (AreaSkeleton)node.getAttribute(Skeleton$.MODULE$.attributeName());
        double w = 0.0;
        double h = 0.0;
        if (info == null) {
            w = camera.metrics().lengthToGu(node.getStyle().getSize(), 0);
            h = node.getStyle().getSize().size() > 1 ? camera.metrics().lengthToGu(node.getStyle().getSize(), 1) : w;
        } else {
            w = info.theSize().x;
            h = info.theSize().y;
        }
        boolean searching = true;
        Point3 p = c.toPos();
        double tbeg = 0.0;
        double tend = 1.0;
        double t = 0.0;
        for (int depth = 0; depth < maxDepth; ++depth) {
            t = tbeg + (tend - tbeg) / (double)2;
            p = this.eval(c.fromPos(), c.byPos1(), c.byPos2(), c.toPos(), t);
            if (ShapeUtil$.MODULE$.isPointIn((GraphicElement)node, p, w, h)) {
                tend = t;
                continue;
            }
            tbeg = t;
        }
        return new Tuple2((Object)p, (Object)BoxesRunTime.boxToDouble((double)t));
    }

    public void main(String[] args) {
        JFrame frame = new JFrame("Test Beziers");
        CubicCurve.MyCanvas canvas = new CubicCurve.MyCanvas();
        frame.setDefaultCloseOperation(3);
        frame.add((Component)canvas, "Center");
        frame.setSize(400, 420);
        frame.setVisible(true);
    }

    private CubicCurve$() {
        MODULE$ = this;
    }
}

