/*
 * Decompiled with CFR 0.152.
 */
package org.grpcmock.definitions.matcher.steps;

import io.grpc.Metadata;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.grpcmock.definitions.BuilderStep;

public interface HeadersMatcherBuilderStep<BUILDER extends HeadersMatcherBuilderStep<BUILDER>>
extends BuilderStep {
    public <T> BUILDER withHeader(@Nonnull Metadata.Key<T> var1, @Nonnull Predicate<T> var2);

    default public BUILDER withHeader(@Nonnull Metadata.Key<byte[]> header, @Nonnull byte[] value) {
        Objects.requireNonNull(value);
        return this.withHeader(header, (T actual) -> Arrays.equals(actual, value));
    }

    default public BUILDER withHeader(@Nonnull Metadata.Key<String> header, @Nonnull String value) {
        Objects.requireNonNull(value);
        return this.withHeader(header, value::equals);
    }

    default public BUILDER withHeader(@Nonnull String headerName, @Nonnull Predicate<String> predicate) {
        Objects.requireNonNull(headerName);
        return this.withHeader(Metadata.Key.of((String)headerName, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), predicate);
    }

    default public BUILDER withHeader(@Nonnull String header, @Nonnull String value) {
        Objects.requireNonNull(value);
        return this.withHeader(header, value::equals);
    }

    default public <T> BUILDER withoutHeader(@Nonnull Metadata.Key<T> headerKey) {
        return this.withHeader(headerKey, Objects::isNull);
    }

    default public BUILDER withoutHeader(@Nonnull String header) {
        return this.withHeader(header, Objects::isNull);
    }
}

