/*
 * Decompiled with CFR 0.152.
 */
package org.grpcmock.definitions.matcher.steps;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.grpcmock.definitions.BuilderStep;

public interface StreamRequestMatcherBuilderStep<BUILDER extends StreamRequestMatcherBuilderStep<BUILDER, ReqT>, ReqT>
extends BuilderStep {
    public BUILDER withRequests(@Nonnull Predicate<List<ReqT>> var1);

    default public BUILDER withRequests(@Nonnull List<ReqT> requests) {
        Objects.requireNonNull(requests);
        return this.withRequests(requests::equals);
    }

    default public BUILDER withRequests(ReqT ... requests) {
        Objects.requireNonNull(requests);
        return this.withRequests(Arrays.asList(requests));
    }

    default public BUILDER withNumberOfRequests(int size) {
        return this.withRequests((List<ReqT> list) -> list.size() == size);
    }

    default public BUILDER withRequestsContaining(@Nonnull Predicate<ReqT> requestPredicate) {
        Objects.requireNonNull(requestPredicate);
        return this.withRequests((List<ReqT> list) -> list.stream().anyMatch(requestPredicate));
    }

    default public BUILDER withRequestsContaining(@Nonnull ReqT request) {
        Objects.requireNonNull(request);
        return this.withRequestsContaining((ReqT)((Predicate<Object>)request::equals));
    }

    default public BUILDER withRequestAtIndex(int index, @Nonnull Predicate<ReqT> requestPredicate) {
        Objects.requireNonNull(requestPredicate);
        return this.withRequests((List<ReqT> list) -> list.size() > index && requestPredicate.test(list.get(index)));
    }

    default public BUILDER withRequestAtIndex(int index, @Nonnull ReqT request) {
        Objects.requireNonNull(request);
        return this.withRequestAtIndex(index, (ReqT)((Predicate<Object>)request::equals));
    }

    default public BUILDER withFirstRequest(@Nonnull Predicate<ReqT> requestPredicate) {
        return this.withRequestAtIndex(0, (ReqT)requestPredicate);
    }

    default public BUILDER withFirstRequest(@Nonnull ReqT request) {
        Objects.requireNonNull(request);
        return this.withFirstRequest((ReqT)((Predicate<Object>)request::equals));
    }
}

