/*
 * Decompiled with CFR 0.152.
 */
package org.grpcmock.interceptors;

import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class CapturedRequest<ReqT> {
    private final MethodDescriptor<ReqT, ?> method;
    private final Metadata headers;
    private final List<ReqT> requests;
    private Status closeStatus;

    CapturedRequest(@Nonnull MethodDescriptor<ReqT, ?> method, @Nonnull Metadata headers, @Nonnull List<ReqT> requests) {
        Objects.requireNonNull(method);
        Objects.requireNonNull(headers);
        Objects.requireNonNull(requests);
        this.method = method;
        this.headers = headers;
        this.requests = requests;
    }

    public MethodDescriptor<ReqT, ?> method() {
        return this.method;
    }

    public Metadata headers() {
        return this.headers;
    }

    public List<ReqT> requests() {
        return Collections.unmodifiableList(this.requests);
    }

    public Status closeStatus() {
        return this.closeStatus;
    }

    void setCloseStatus(@Nonnull Status closeStatus) {
        if (Objects.isNull(this.closeStatus)) {
            this.closeStatus = closeStatus;
        }
    }

    public String toString() {
        return String.format("Request to %s method%nwith headers:%n%s%nwith request:%n%s", this.method.getFullMethodName(), this.headers, this.requests.size() == 1 ? this.requests.get(0) : this.requests);
    }
}

