/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import org.hbase.async.Bytes;
import org.hbase.async.HBaseRpc;
import org.hbase.async.ScanFilter;
import org.hbase.async.generated.FilterPB;
import org.jboss.netty.buffer.ChannelBuffer;

public final class ColumnRangeFilter
extends ScanFilter {
    private static final byte[] NAME = Bytes.ISO88591("org.apache.hadoop.hbase.filter.ColumnRangeFilter");
    private final byte[] start_column;
    private final boolean start_inclusive;
    private final byte[] stop_column;
    private final boolean stop_inclusive;

    public ColumnRangeFilter(String start_column, String stop_column) {
        this(Bytes.UTF8(start_column), true, Bytes.UTF8(stop_column), true);
    }

    public ColumnRangeFilter(byte[] start_column, byte[] stop_column) {
        this(start_column, true, stop_column, true);
    }

    public ColumnRangeFilter(String start_column, boolean start_inclusive, String stop_column, boolean stop_inclusive) {
        this(Bytes.UTF8(start_column), start_inclusive, Bytes.UTF8(stop_column), stop_inclusive);
    }

    public ColumnRangeFilter(byte[] start_column, boolean start_inclusive, byte[] stop_column, boolean stop_inclusive) {
        this.start_column = start_column;
        this.start_inclusive = start_inclusive;
        this.stop_column = stop_column;
        this.stop_inclusive = stop_inclusive;
    }

    @Override
    byte[] serialize() {
        FilterPB.ColumnRangeFilter.Builder filter = FilterPB.ColumnRangeFilter.newBuilder();
        if (this.start_column != null) {
            filter.setMinColumn(Bytes.wrap(this.start_column));
            if (this.start_inclusive) {
                filter.setMinColumnInclusive(true);
            }
        }
        if (this.stop_column != null) {
            filter.setMaxColumn(Bytes.wrap(this.stop_column));
            if (this.stop_inclusive) {
                filter.setMaxColumnInclusive(true);
            }
        }
        return filter.build().toByteArray();
    }

    @Override
    byte[] name() {
        return NAME;
    }

    @Override
    int predictSerializedSize() {
        return 1 + NAME.length + 1 + 3 + (this.start_column == null ? 0 : this.start_column.length) + 1 + 1 + 3 + (this.stop_column == null ? 0 : this.stop_column.length) + 1;
    }

    @Override
    void serializeOld(ChannelBuffer buf) {
        buf.writeByte((int)((byte)NAME.length));
        buf.writeBytes(NAME);
        if (this.start_column == null) {
            buf.writeByte(1);
            buf.writeByte(0);
        } else {
            buf.writeByte(0);
            HBaseRpc.writeByteArray(buf, this.start_column);
        }
        buf.writeByte(this.start_inclusive ? 1 : 0);
        if (this.stop_column == null) {
            buf.writeByte(1);
            buf.writeByte(0);
        } else {
            buf.writeByte(0);
            HBaseRpc.writeByteArray(buf, this.stop_column);
        }
        buf.writeByte(this.stop_inclusive ? 1 : 0);
    }

    public String toString() {
        return "ColumnRangeFilter(start=" + Bytes.pretty(this.start_column) + (this.start_inclusive ? " (in" : " (ex") + "clusive), stop=" + Bytes.pretty(this.stop_column) + (this.stop_inclusive ? " (in" : " (ex") + "clusive))";
    }
}

