/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TransactionHelper;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.enhanced.OptimizerFactory;
import org.hibernate.jdbc.util.FormatStyle;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableGenerator
extends TransactionHelper
implements PersistentIdentifierGenerator,
Configurable {
    private static final Logger log = LoggerFactory.getLogger(TableGenerator.class);
    public static final String CONFIG_PREFER_SEGMENT_PER_ENTITY = "prefer_entity_table_as_segment_value";
    public static final String TABLE_PARAM = "table_name";
    public static final String DEF_TABLE = "hibernate_sequences";
    public static final String VALUE_COLUMN_PARAM = "value_column_name";
    public static final String DEF_VALUE_COLUMN = "next_val";
    public static final String SEGMENT_COLUMN_PARAM = "segment_column_name";
    public static final String DEF_SEGMENT_COLUMN = "sequence_name";
    public static final String SEGMENT_VALUE_PARAM = "segment_value";
    public static final String DEF_SEGMENT_VALUE = "default";
    public static final String SEGMENT_LENGTH_PARAM = "segment_value_length";
    public static final int DEF_SEGMENT_LENGTH = 255;
    public static final String INITIAL_PARAM = "initial_value";
    public static final int DEFAULT_INITIAL_VALUE = 1;
    public static final String INCREMENT_PARAM = "increment_size";
    public static final int DEFAULT_INCREMENT_SIZE = 1;
    public static final String OPT_PARAM = "optimizer";
    private Type identifierType;
    private String tableName;
    private String segmentColumnName;
    private String segmentValue;
    private int segmentValueLength;
    private String valueColumnName;
    private int initialValue;
    private int incrementSize;
    private String selectQuery;
    private String insertQuery;
    private String updateQuery;
    private Optimizer optimizer;
    private long accessCount = 0L;

    public Object generatorKey() {
        return this.tableName;
    }

    public final Type getIdentifierType() {
        return this.identifierType;
    }

    public final String getTableName() {
        return this.tableName;
    }

    public final String getSegmentColumnName() {
        return this.segmentColumnName;
    }

    public final String getSegmentValue() {
        return this.segmentValue;
    }

    public final int getSegmentValueLength() {
        return this.segmentValueLength;
    }

    public final String getValueColumnName() {
        return this.valueColumnName;
    }

    public final int getInitialValue() {
        return this.initialValue;
    }

    public final int getIncrementSize() {
        return this.incrementSize;
    }

    public final Optimizer getOptimizer() {
        return this.optimizer;
    }

    public final long getTableAccessCount() {
        return this.accessCount;
    }

    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        this.identifierType = type;
        this.tableName = this.determineGeneratorTableName(params, dialect);
        this.segmentColumnName = this.determineSegmentColumnName(params, dialect);
        this.valueColumnName = this.determineValueColumnName(params, dialect);
        this.segmentValue = this.determineSegmentValue(params);
        this.segmentValueLength = this.determineSegmentColumnSize(params);
        this.initialValue = this.determineInitialValue(params);
        this.incrementSize = this.determineIncrementSize(params);
        this.selectQuery = this.buildSelectQuery(dialect);
        this.updateQuery = this.buildUpdateQuery();
        this.insertQuery = this.buildInsertQuery();
        String defaultPooledOptimizerStrategy = PropertiesHelper.getBoolean("hibernate.id.optimizer.pooled.prefer_lo", params, false) ? "pooled-lo" : "pooled";
        String defaultOptimizerStrategy = this.incrementSize <= 1 ? "none" : defaultPooledOptimizerStrategy;
        String optimizationStrategy = PropertiesHelper.getString(OPT_PARAM, params, defaultOptimizerStrategy);
        this.optimizer = OptimizerFactory.buildOptimizer(optimizationStrategy, this.identifierType.getReturnedClass(), this.incrementSize, PropertiesHelper.getInt(INITIAL_PARAM, params, -1));
    }

    protected String determineGeneratorTableName(Properties params, Dialect dialect) {
        boolean isGivenNameUnqualified;
        String name = PropertiesHelper.getString(TABLE_PARAM, params, DEF_TABLE);
        boolean bl = isGivenNameUnqualified = name.indexOf(46) < 0;
        if (isGivenNameUnqualified) {
            ObjectNameNormalizer normalizer = (ObjectNameNormalizer)params.get("identifier_normalizer");
            name = normalizer.normalizeIdentifierQuoting(name);
            String schemaName = normalizer.normalizeIdentifierQuoting(params.getProperty("schema"));
            String catalogName = normalizer.normalizeIdentifierQuoting(params.getProperty("catalog"));
            name = Table.qualify(dialect.quote(catalogName), dialect.quote(schemaName), dialect.quote(name));
        }
        return name;
    }

    protected String determineSegmentColumnName(Properties params, Dialect dialect) {
        ObjectNameNormalizer normalizer = (ObjectNameNormalizer)params.get("identifier_normalizer");
        String name = PropertiesHelper.getString(SEGMENT_COLUMN_PARAM, params, DEF_SEGMENT_COLUMN);
        return dialect.quote(normalizer.normalizeIdentifierQuoting(name));
    }

    protected String determineValueColumnName(Properties params, Dialect dialect) {
        ObjectNameNormalizer normalizer = (ObjectNameNormalizer)params.get("identifier_normalizer");
        String name = PropertiesHelper.getString(VALUE_COLUMN_PARAM, params, DEF_VALUE_COLUMN);
        return dialect.quote(normalizer.normalizeIdentifierQuoting(name));
    }

    protected String determineSegmentValue(Properties params) {
        String segmentValue = params.getProperty(SEGMENT_VALUE_PARAM);
        if (StringHelper.isEmpty(segmentValue)) {
            segmentValue = this.determineDefaultSegmentValue(params);
        }
        return segmentValue;
    }

    protected String determineDefaultSegmentValue(Properties params) {
        boolean preferSegmentPerEntity = PropertiesHelper.getBoolean(CONFIG_PREFER_SEGMENT_PER_ENTITY, params, false);
        String defaultToUse = preferSegmentPerEntity ? params.getProperty("target_table") : DEF_SEGMENT_VALUE;
        log.info("explicit segment value for id generator [" + this.tableName + '.' + this.segmentColumnName + "] suggested; using default [" + defaultToUse + "]");
        return defaultToUse;
    }

    protected int determineSegmentColumnSize(Properties params) {
        return PropertiesHelper.getInt(SEGMENT_LENGTH_PARAM, params, 255);
    }

    protected int determineInitialValue(Properties params) {
        return PropertiesHelper.getInt(INITIAL_PARAM, params, 1);
    }

    protected int determineIncrementSize(Properties params) {
        return PropertiesHelper.getInt(INCREMENT_PARAM, params, 1);
    }

    protected String buildSelectQuery(Dialect dialect) {
        String alias = "tbl";
        String query = "select " + StringHelper.qualify("tbl", this.valueColumnName) + " from " + this.tableName + ' ' + "tbl" + " where " + StringHelper.qualify("tbl", this.segmentColumnName) + "=?";
        LockOptions lockOptions = new LockOptions(LockMode.PESSIMISTIC_WRITE);
        lockOptions.setAliasSpecificLockMode("tbl", LockMode.PESSIMISTIC_WRITE);
        Map<String, String[]> updateTargetColumnsMap = Collections.singletonMap("tbl", new String[]{this.valueColumnName});
        return dialect.applyLocksToSql(query, lockOptions, updateTargetColumnsMap);
    }

    protected String buildUpdateQuery() {
        return "update " + this.tableName + " set " + this.valueColumnName + "=? " + " where " + this.valueColumnName + "=? and " + this.segmentColumnName + "=?";
    }

    protected String buildInsertQuery() {
        return "insert into " + this.tableName + " (" + this.segmentColumnName + ", " + this.valueColumnName + ") " + " values (?,?)";
    }

    public synchronized Serializable generate(final SessionImplementor session, Object obj) {
        return this.optimizer.generate(new AccessCallback(){

            public IntegralDataTypeHolder getNextValue() {
                return (IntegralDataTypeHolder)TableGenerator.this.doWorkInNewTransaction(session);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable doWorkInCurrentTransaction(Connection conn, String sql) throws SQLException {
        int rows;
        IntegralDataTypeHolder value = IdentifierGeneratorHelper.getIntegralDataTypeHolder(this.identifierType.getReturnedClass());
        do {
            SQL_STATEMENT_LOGGER.logStatement(this.selectQuery, FormatStyle.BASIC);
            PreparedStatement selectPS = conn.prepareStatement(this.selectQuery);
            try {
                selectPS.setString(1, this.segmentValue);
                ResultSet selectRS = selectPS.executeQuery();
                if (!selectRS.next()) {
                    value.initialize(this.initialValue);
                    Statement insertPS = null;
                    try {
                        SQL_STATEMENT_LOGGER.logStatement(this.insertQuery, FormatStyle.BASIC);
                        insertPS = conn.prepareStatement(this.insertQuery);
                        insertPS.setString(1, this.segmentValue);
                        value.bind((PreparedStatement)insertPS, 2);
                        insertPS.execute();
                    }
                    finally {
                        if (insertPS != null) {
                            insertPS.close();
                        }
                    }
                } else {
                    value.initialize(selectRS, 1L);
                }
                selectRS.close();
            }
            catch (SQLException sqle) {
                log.error("could not read or init a hi value", (Throwable)sqle);
                throw sqle;
            }
            finally {
                selectPS.close();
            }
            SQL_STATEMENT_LOGGER.logStatement(this.updateQuery, FormatStyle.BASIC);
            PreparedStatement updatePS = conn.prepareStatement(this.updateQuery);
            try {
                IntegralDataTypeHolder updateValue = value.copy();
                if (this.optimizer.applyIncrementSizeToSourceValues()) {
                    updateValue.add(this.incrementSize);
                } else {
                    updateValue.increment();
                }
                updateValue.bind(updatePS, 1);
                value.bind(updatePS, 2);
                updatePS.setString(3, this.segmentValue);
                rows = updatePS.executeUpdate();
            }
            catch (SQLException sqle) {
                log.error("could not updateQuery hi value in: " + this.tableName, (Throwable)sqle);
                throw sqle;
            }
            finally {
                updatePS.close();
            }
        } while (rows == 0);
        ++this.accessCount;
        return value;
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{new StringBuffer().append(dialect.getCreateTableString()).append(' ').append(this.tableName).append(" ( ").append(this.segmentColumnName).append(' ').append(dialect.getTypeName(12, this.segmentValueLength, 0, 0)).append(" not null ").append(",  ").append(this.valueColumnName).append(' ').append(dialect.getTypeName(-5)).append(", primary key ( ").append(this.segmentColumnName).append(" ) ) ").toString()};
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        StringBuffer sqlDropString = new StringBuffer().append("drop table ");
        if (dialect.supportsIfExistsBeforeTableName()) {
            sqlDropString.append("if exists ");
        }
        sqlDropString.append(this.tableName).append(dialect.getCascadeConstraintsString());
        if (dialect.supportsIfExistsAfterTableName()) {
            sqlDropString.append(" if exists");
        }
        return new String[]{sqlDropString.toString()};
    }
}

