/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.service.internal;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.event.internal.DefaultAutoFlushEventListener;
import org.hibernate.event.internal.DefaultDeleteEventListener;
import org.hibernate.event.internal.DefaultDirtyCheckEventListener;
import org.hibernate.event.internal.DefaultEvictEventListener;
import org.hibernate.event.internal.DefaultFlushEntityEventListener;
import org.hibernate.event.internal.DefaultFlushEventListener;
import org.hibernate.event.internal.DefaultInitializeCollectionEventListener;
import org.hibernate.event.internal.DefaultLoadEventListener;
import org.hibernate.event.internal.DefaultLockEventListener;
import org.hibernate.event.internal.DefaultMergeEventListener;
import org.hibernate.event.internal.DefaultPersistEventListener;
import org.hibernate.event.internal.DefaultPersistOnFlushEventListener;
import org.hibernate.event.internal.DefaultPostLoadEventListener;
import org.hibernate.event.internal.DefaultPreLoadEventListener;
import org.hibernate.event.internal.DefaultRefreshEventListener;
import org.hibernate.event.internal.DefaultReplicateEventListener;
import org.hibernate.event.internal.DefaultSaveEventListener;
import org.hibernate.event.internal.DefaultSaveOrUpdateEventListener;
import org.hibernate.event.internal.DefaultUpdateEventListener;
import org.hibernate.event.service.internal.EventListenerGroupImpl;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistrationException;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;

public class EventListenerRegistryImpl
implements EventListenerRegistry {
    private Map<Class, Object> listenerClassToInstanceMap = new HashMap<Class, Object>();
    private Map<EventType, EventListenerGroupImpl> registeredEventListenersMap = EventListenerRegistryImpl.prepareListenerMap();

    public <T> EventListenerGroupImpl<T> getEventListenerGroup(EventType<T> eventType) {
        EventListenerGroupImpl listeners = this.registeredEventListenersMap.get(eventType);
        if (listeners == null) {
            throw new HibernateException("Unable to find listeners for type [" + eventType.eventName() + "]");
        }
        return listeners;
    }

    @Override
    public void addDuplicationStrategy(DuplicationStrategy strategy) {
        for (EventListenerGroupImpl group : this.registeredEventListenersMap.values()) {
            group.addDuplicationStrategy(strategy);
        }
    }

    @Override
    public <T> void setListeners(EventType<T> type, Class<T> ... listenerClasses) {
        this.setListeners(type, this.resolveListenerInstances(type, listenerClasses));
    }

    private <T> T[] resolveListenerInstances(EventType<T> type, Class<T> ... listenerClasses) {
        Object[] listeners = (Object[])Array.newInstance(type.baseListenerInterface(), listenerClasses.length);
        for (int i = 0; i < listenerClasses.length; ++i) {
            listeners[i] = this.resolveListenerInstance(listenerClasses[i]);
        }
        return listeners;
    }

    private <T> T resolveListenerInstance(Class<T> listenerClass) {
        Object listenerInstance = this.listenerClassToInstanceMap.get(listenerClass);
        if (listenerInstance == null) {
            listenerInstance = this.instantiateListener(listenerClass);
            this.listenerClassToInstanceMap.put(listenerClass, listenerInstance);
        }
        return (T)listenerInstance;
    }

    private <T> T instantiateListener(Class<T> listenerClass) {
        try {
            return listenerClass.newInstance();
        }
        catch (Exception e) {
            throw new EventListenerRegistrationException("Unable to instantiate specified event listener class: " + listenerClass.getName(), e);
        }
    }

    @Override
    public <T> void setListeners(EventType<T> type, T ... listeners) {
        EventListenerGroup registeredListeners = this.getEventListenerGroup((EventType)type);
        ((EventListenerGroupImpl)registeredListeners).clear();
        if (listeners != null) {
            int max = listeners.length;
            for (int i = 0; i < max; ++i) {
                ((EventListenerGroupImpl)registeredListeners).appendListener(listeners[i]);
            }
        }
    }

    @Override
    public <T> void appendListeners(EventType<T> type, Class<T> ... listenerClasses) {
        this.appendListeners(type, this.resolveListenerInstances(type, listenerClasses));
    }

    @Override
    public <T> void appendListeners(EventType<T> type, T ... listeners) {
        ((EventListenerGroupImpl)this.getEventListenerGroup((EventType)type)).appendListeners(listeners);
    }

    @Override
    public <T> void prependListeners(EventType<T> type, Class<T> ... listenerClasses) {
        this.prependListeners(type, this.resolveListenerInstances(type, listenerClasses));
    }

    @Override
    public <T> void prependListeners(EventType<T> type, T ... listeners) {
        ((EventListenerGroupImpl)this.getEventListenerGroup((EventType)type)).prependListeners(listeners);
    }

    private static Map<EventType, EventListenerGroupImpl> prepareListenerMap() {
        HashMap<EventType, EventListenerGroupImpl> workMap = new HashMap<EventType, EventListenerGroupImpl>();
        EventListenerRegistryImpl.prepareListeners(EventType.AUTO_FLUSH, new DefaultAutoFlushEventListener(), workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.PERSIST, new DefaultPersistEventListener(), workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.PERSIST_ONFLUSH, new DefaultPersistOnFlushEventListener(), workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.DELETE, new DefaultDeleteEventListener(), workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.DIRTY_CHECK, new DefaultDirtyCheckEventListener(), workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.EVICT, new DefaultEvictEventListener(), workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.FLUSH, new DefaultFlushEventListener(), workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.FLUSH_ENTITY, new DefaultFlushEntityEventListener(), workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.LOAD, new DefaultLoadEventListener(), workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.INIT_COLLECTION, new DefaultInitializeCollectionEventListener(), workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.LOCK, new DefaultLockEventListener(), workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.MERGE, new DefaultMergeEventListener(), workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.PRE_COLLECTION_RECREATE, workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.PRE_COLLECTION_REMOVE, workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.PRE_COLLECTION_UPDATE, workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.PRE_DELETE, workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.PRE_INSERT, workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.PRE_LOAD, new DefaultPreLoadEventListener(), workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.PRE_UPDATE, workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_COLLECTION_RECREATE, workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_COLLECTION_REMOVE, workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_COLLECTION_UPDATE, workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_COMMIT_DELETE, workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_COMMIT_INSERT, workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_COMMIT_UPDATE, workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_DELETE, workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_INSERT, workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_LOAD, new DefaultPostLoadEventListener(), workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_UPDATE, workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.UPDATE, new DefaultUpdateEventListener(), workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.REFRESH, new DefaultRefreshEventListener(), workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.REPLICATE, new DefaultReplicateEventListener(), workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.SAVE, new DefaultSaveEventListener(), workMap);
        EventListenerRegistryImpl.prepareListeners(EventType.SAVE_UPDATE, new DefaultSaveOrUpdateEventListener(), workMap);
        return Collections.unmodifiableMap(workMap);
    }

    private static <T> void prepareListeners(EventType<T> type, Map<EventType, EventListenerGroupImpl> map) {
        EventListenerRegistryImpl.prepareListeners(type, null, map);
    }

    private static <T> void prepareListeners(EventType<T> type, T defaultListener, Map<EventType, EventListenerGroupImpl> map) {
        EventListenerGroupImpl<T> listeners = new EventListenerGroupImpl<T>(type);
        if (defaultListener != null) {
            listeners.appendListener(defaultListener);
        }
        map.put(type, listeners);
    }
}

