/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.criteria;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.EnhancedProjection;
import org.hibernate.criterion.Projection;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.hql.internal.ast.util.SessionFactoryHelper;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.criteria.ComponentCollectionCriteriaInfoProvider;
import org.hibernate.loader.criteria.CriteriaInfoProvider;
import org.hibernate.loader.criteria.EntityCriteriaInfoProvider;
import org.hibernate.loader.criteria.ScalarCollectionCriteriaInfoProvider;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.JoinType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.StringRepresentableType;
import org.hibernate.type.Type;

public class CriteriaQueryTranslator
implements CriteriaQuery {
    public static final String ROOT_SQL_ALIAS = "this_";
    private CriteriaQuery outerQueryTranslator;
    private final CriteriaImpl rootCriteria;
    private final String rootEntityName;
    private final String rootSQLAlias;
    private int aliasCount = 0;
    private final Map criteriaInfoMap = new LinkedHashMap();
    private final Map nameCriteriaInfoMap = new LinkedHashMap();
    private final Map criteriaSQLAliasMap = new HashMap();
    private final Map aliasCriteriaMap = new HashMap();
    private final Map associationPathCriteriaMap = new LinkedHashMap();
    private final Map<String, JoinType> associationPathJoinTypesMap = new LinkedHashMap<String, JoinType>();
    private final Map withClauseMap = new HashMap();
    private final SessionFactoryImplementor sessionFactory;
    private final SessionFactoryHelper helper;

    public CriteriaQueryTranslator(SessionFactoryImplementor factory, CriteriaImpl criteria, String rootEntityName, String rootSQLAlias, CriteriaQuery outerQuery) throws HibernateException {
        this(factory, criteria, rootEntityName, rootSQLAlias);
        this.outerQueryTranslator = outerQuery;
    }

    public CriteriaQueryTranslator(SessionFactoryImplementor factory, CriteriaImpl criteria, String rootEntityName, String rootSQLAlias) throws HibernateException {
        this.rootCriteria = criteria;
        this.rootEntityName = rootEntityName;
        this.sessionFactory = factory;
        this.rootSQLAlias = rootSQLAlias;
        this.helper = new SessionFactoryHelper(factory);
        this.createAliasCriteriaMap();
        this.createAssociationPathCriteriaMap();
        this.createCriteriaEntityNameMap();
        this.createCriteriaSQLAliasMap();
    }

    @Override
    public String generateSQLAlias() {
        return StringHelper.generateAlias("this", this.aliasCount) + '_';
    }

    public String getRootSQLALias() {
        return this.rootSQLAlias;
    }

    private Criteria getAliasedCriteria(String alias) {
        return (Criteria)this.aliasCriteriaMap.get(alias);
    }

    public boolean isJoin(String path) {
        return this.associationPathCriteriaMap.containsKey(path);
    }

    public JoinType getJoinType(String path) {
        JoinType result = this.associationPathJoinTypesMap.get(path);
        return result == null ? JoinType.INNER_JOIN : result;
    }

    public Criteria getCriteria(String path) {
        return (Criteria)this.associationPathCriteriaMap.get(path);
    }

    public Set getQuerySpaces() {
        HashSet<Serializable> result = new HashSet<Serializable>();
        for (CriteriaInfoProvider info : this.criteriaInfoMap.values()) {
            result.addAll(Arrays.asList(info.getSpaces()));
        }
        return result;
    }

    private void createAliasCriteriaMap() {
        this.aliasCriteriaMap.put(this.rootCriteria.getAlias(), this.rootCriteria);
        Iterator iter = this.rootCriteria.iterateSubcriteria();
        while (iter.hasNext()) {
            Criteria old;
            Criteria subcriteria = (Criteria)iter.next();
            if (subcriteria.getAlias() == null || (old = this.aliasCriteriaMap.put(subcriteria.getAlias(), subcriteria)) == null) continue;
            throw new QueryException("duplicate alias: " + subcriteria.getAlias());
        }
    }

    private void createAssociationPathCriteriaMap() {
        Iterator iter = this.rootCriteria.iterateSubcriteria();
        while (iter.hasNext()) {
            CriteriaImpl.Subcriteria crit = (CriteriaImpl.Subcriteria)iter.next();
            String wholeAssociationPath = this.getWholeAssociationPath(crit);
            Object old = this.associationPathCriteriaMap.put(wholeAssociationPath, crit);
            if (old != null) {
                throw new QueryException("duplicate association path: " + wholeAssociationPath);
            }
            JoinType joinType = crit.getJoinType();
            old = this.associationPathJoinTypesMap.put(wholeAssociationPath, joinType);
            if (old != null) {
                throw new QueryException("duplicate association path: " + wholeAssociationPath);
            }
            if (crit.getWithClause() == null) continue;
            this.withClauseMap.put(wholeAssociationPath, crit.getWithClause());
        }
    }

    private String getWholeAssociationPath(CriteriaImpl.Subcriteria subcriteria) {
        String testAlias;
        String path = subcriteria.getPath();
        Criteria parent = null;
        if (path.indexOf(46) > 0 && !(testAlias = StringHelper.root(path)).equals(subcriteria.getAlias())) {
            parent = (Criteria)this.aliasCriteriaMap.get(testAlias);
        }
        if (parent == null) {
            parent = subcriteria.getParent();
        } else {
            path = StringHelper.unroot(path);
        }
        if (parent.equals(this.rootCriteria)) {
            return path;
        }
        return this.getWholeAssociationPath((CriteriaImpl.Subcriteria)parent) + '.' + path;
    }

    private void createCriteriaEntityNameMap() {
        EntityCriteriaInfoProvider rootProvider = new EntityCriteriaInfoProvider((Queryable)this.sessionFactory.getEntityPersister(this.rootEntityName));
        this.criteriaInfoMap.put(this.rootCriteria, rootProvider);
        this.nameCriteriaInfoMap.put(rootProvider.getName(), rootProvider);
        for (Map.Entry me : this.associationPathCriteriaMap.entrySet()) {
            CriteriaInfoProvider info = this.getPathInfo((String)me.getKey());
            this.criteriaInfoMap.put(me.getValue(), info);
            this.nameCriteriaInfoMap.put(info.getName(), info);
        }
    }

    private CriteriaInfoProvider getPathInfo(String path) {
        StringTokenizer tokens = new StringTokenizer(path, ".");
        String componentPath = "";
        CriteriaInfoProvider provider = (CriteriaInfoProvider)this.nameCriteriaInfoMap.get(this.rootEntityName);
        while (tokens.hasMoreTokens()) {
            Type type = provider.getType(componentPath = componentPath + tokens.nextToken());
            if (type.isAssociationType()) {
                Type elementType;
                AssociationType atype = (AssociationType)type;
                CollectionType ctype = type.isCollectionType() ? (CollectionType)type : null;
                Type type2 = elementType = ctype != null ? ctype.getElementType(this.sessionFactory) : null;
                provider = ctype != null && elementType.isComponentType() ? new ComponentCollectionCriteriaInfoProvider(this.helper.getCollectionPersister(ctype.getRole())) : (ctype != null && !elementType.isEntityType() ? new ScalarCollectionCriteriaInfoProvider(this.helper, ctype.getRole()) : new EntityCriteriaInfoProvider((Queryable)this.sessionFactory.getEntityPersister(atype.getAssociatedEntityName(this.sessionFactory))));
                componentPath = "";
                continue;
            }
            if (type.isComponentType()) {
                if (!tokens.hasMoreTokens()) {
                    throw new QueryException("Criteria objects cannot be created directly on components.  Create a criteria on owning entity and use a dotted property to access component property: " + path);
                }
                componentPath = componentPath + '.';
                continue;
            }
            throw new QueryException("not an association: " + componentPath);
        }
        return provider;
    }

    public int getSQLAliasCount() {
        return this.criteriaSQLAliasMap.size();
    }

    private void createCriteriaSQLAliasMap() {
        int i = 0;
        for (Map.Entry me : this.criteriaInfoMap.entrySet()) {
            Criteria crit = (Criteria)me.getKey();
            String alias = crit.getAlias();
            if (alias == null) {
                alias = ((CriteriaInfoProvider)me.getValue()).getName();
            }
            this.criteriaSQLAliasMap.put(crit, StringHelper.generateAlias(alias, i++));
        }
        this.criteriaSQLAliasMap.put(this.rootCriteria, this.rootSQLAlias);
    }

    public CriteriaImpl getRootCriteria() {
        return this.rootCriteria;
    }

    public QueryParameters getQueryParameters() {
        LockOptions lockOptions = new LockOptions();
        RowSelection selection = new RowSelection();
        selection.setFirstRow(this.rootCriteria.getFirstResult());
        selection.setMaxRows(this.rootCriteria.getMaxResults());
        selection.setTimeout(this.rootCriteria.getTimeout());
        selection.setFetchSize(this.rootCriteria.getFetchSize());
        for (Map.Entry me : this.rootCriteria.getLockModes().entrySet()) {
            Criteria subcriteria = this.getAliasedCriteria((String)me.getKey());
            lockOptions.setAliasSpecificLockMode(this.getSQLAlias(subcriteria), (LockMode)((Object)me.getValue()));
        }
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Type> types = new ArrayList<Type>();
        Iterator iter = this.rootCriteria.iterateSubcriteria();
        while (iter.hasNext()) {
            CriteriaImpl.Subcriteria subcriteria = (CriteriaImpl.Subcriteria)iter.next();
            LockMode lm = subcriteria.getLockMode();
            if (lm != null) {
                lockOptions.setAliasSpecificLockMode(this.getSQLAlias(subcriteria), lm);
            }
            if (subcriteria.getWithClause() == null) continue;
            TypedValue[] tv = subcriteria.getWithClause().getTypedValues(subcriteria, this);
            for (int i = 0; i < tv.length; ++i) {
                values.add(tv[i].getValue());
                types.add(tv[i].getType());
            }
        }
        iter = this.rootCriteria.iterateExpressionEntries();
        while (iter.hasNext()) {
            CriteriaImpl.CriterionEntry ce = (CriteriaImpl.CriterionEntry)iter.next();
            TypedValue[] tv = ce.getCriterion().getTypedValues(ce.getCriteria(), this);
            for (int i = 0; i < tv.length; ++i) {
                values.add(tv[i].getValue());
                types.add(tv[i].getType());
            }
        }
        Object[] valueArray = values.toArray();
        Type[] typeArray = ArrayHelper.toTypeArray(types);
        return new QueryParameters(typeArray, valueArray, lockOptions, selection, this.rootCriteria.isReadOnlyInitialized(), this.rootCriteria.isReadOnlyInitialized() ? this.rootCriteria.isReadOnly() : false, this.rootCriteria.getCacheable(), this.rootCriteria.getCacheRegion(), this.rootCriteria.getComment(), this.rootCriteria.isLookupByNaturalKey(), this.rootCriteria.getResultTransformer());
    }

    public boolean hasProjection() {
        return this.rootCriteria.getProjection() != null;
    }

    public String getGroupBy() {
        if (this.rootCriteria.getProjection().isGrouped()) {
            return this.rootCriteria.getProjection().toGroupSqlString(this.rootCriteria.getProjectionCriteria(), this);
        }
        return "";
    }

    public String getSelect() {
        return this.rootCriteria.getProjection().toSqlString(this.rootCriteria.getProjectionCriteria(), 0, this);
    }

    Type getResultType(Criteria criteria) {
        return this.getFactory().getTypeResolver().getTypeFactory().manyToOne(this.getEntityName(criteria));
    }

    public Type[] getProjectedTypes() {
        return this.rootCriteria.getProjection().getTypes(this.rootCriteria, this);
    }

    public String[] getProjectedColumnAliases() {
        return this.rootCriteria.getProjection() instanceof EnhancedProjection ? ((EnhancedProjection)this.rootCriteria.getProjection()).getColumnAliases(0, this.rootCriteria, this) : this.rootCriteria.getProjection().getColumnAliases(0);
    }

    public String[] getProjectedAliases() {
        return this.rootCriteria.getProjection().getAliases();
    }

    public String getWhereCondition() {
        StringBuffer condition = new StringBuffer(30);
        Iterator criterionIterator = this.rootCriteria.iterateExpressionEntries();
        while (criterionIterator.hasNext()) {
            CriteriaImpl.CriterionEntry entry = (CriteriaImpl.CriterionEntry)criterionIterator.next();
            String sqlString = entry.getCriterion().toSqlString(entry.getCriteria(), this);
            condition.append(sqlString);
            if (!criterionIterator.hasNext()) continue;
            condition.append(" and ");
        }
        return condition.toString();
    }

    public String getOrderBy() {
        StringBuffer orderBy = new StringBuffer(30);
        Iterator criterionIterator = this.rootCriteria.iterateOrderings();
        while (criterionIterator.hasNext()) {
            CriteriaImpl.OrderEntry oe = (CriteriaImpl.OrderEntry)criterionIterator.next();
            orderBy.append(oe.getOrder().toSqlString(oe.getCriteria(), this));
            if (!criterionIterator.hasNext()) continue;
            orderBy.append(", ");
        }
        return orderBy.toString();
    }

    @Override
    public SessionFactoryImplementor getFactory() {
        return this.sessionFactory;
    }

    @Override
    public String getSQLAlias(Criteria criteria) {
        return (String)this.criteriaSQLAliasMap.get(criteria);
    }

    @Override
    public String getEntityName(Criteria criteria) {
        return ((CriteriaInfoProvider)this.criteriaInfoMap.get(criteria)).getName();
    }

    @Override
    public String getColumn(Criteria criteria, String propertyName) {
        String[] cols = this.getColumns(propertyName, criteria);
        if (cols.length != 1) {
            throw new QueryException("property does not map to a single column: " + propertyName);
        }
        return cols[0];
    }

    @Override
    public String[] getColumnsUsingProjection(Criteria subcriteria, String propertyName) throws HibernateException {
        Projection projection = this.rootCriteria.getProjection();
        String[] projectionColumns = null;
        if (projection != null) {
            String[] stringArray = projectionColumns = projection instanceof EnhancedProjection ? ((EnhancedProjection)projection).getColumnAliases(propertyName, 0, this.rootCriteria, this) : projection.getColumnAliases(propertyName, 0);
        }
        if (projectionColumns == null) {
            try {
                return this.getColumns(propertyName, subcriteria);
            }
            catch (HibernateException he) {
                if (this.outerQueryTranslator != null) {
                    return this.outerQueryTranslator.getColumnsUsingProjection(subcriteria, propertyName);
                }
                throw he;
            }
        }
        return projectionColumns;
    }

    @Override
    public String[] getIdentifierColumns(Criteria subcriteria) {
        String[] idcols = ((Loadable)((Object)this.getPropertyMapping(this.getEntityName(subcriteria)))).getIdentifierColumnNames();
        return StringHelper.qualify(this.getSQLAlias(subcriteria), idcols);
    }

    @Override
    public Type getIdentifierType(Criteria subcriteria) {
        return ((Loadable)((Object)this.getPropertyMapping(this.getEntityName(subcriteria)))).getIdentifierType();
    }

    @Override
    public TypedValue getTypedIdentifierValue(Criteria subcriteria, Object value) {
        Loadable loadable = (Loadable)((Object)this.getPropertyMapping(this.getEntityName(subcriteria)));
        return new TypedValue(loadable.getIdentifierType(), value, EntityMode.POJO);
    }

    @Override
    public String[] getColumns(String propertyName, Criteria subcriteria) throws HibernateException {
        return this.getPropertyMapping(this.getEntityName(subcriteria, propertyName)).toColumns(this.getSQLAlias(subcriteria, propertyName), this.getPropertyName(propertyName));
    }

    @Override
    public String[] findColumns(String propertyName, Criteria subcriteria) throws HibernateException {
        try {
            return this.getColumns(propertyName, subcriteria);
        }
        catch (HibernateException he) {
            if (this.outerQueryTranslator != null) {
                return this.outerQueryTranslator.findColumns(propertyName, subcriteria);
            }
            throw he;
        }
    }

    @Override
    public Type getTypeUsingProjection(Criteria subcriteria, String propertyName) throws HibernateException {
        Type[] projectionTypes;
        Projection projection = this.rootCriteria.getProjection();
        Type[] typeArray = projectionTypes = projection == null ? null : projection.getTypes(propertyName, subcriteria, this);
        if (projectionTypes == null) {
            try {
                return this.getType(subcriteria, propertyName);
            }
            catch (HibernateException he) {
                if (this.outerQueryTranslator != null) {
                    return this.outerQueryTranslator.getType(subcriteria, propertyName);
                }
                throw he;
            }
        }
        if (projectionTypes.length != 1) {
            throw new QueryException("not a single-length projection: " + propertyName);
        }
        return projectionTypes[0];
    }

    @Override
    public Type getType(Criteria subcriteria, String propertyName) throws HibernateException {
        return this.getPropertyMapping(this.getEntityName(subcriteria, propertyName)).toType(this.getPropertyName(propertyName));
    }

    @Override
    public TypedValue getTypedValue(Criteria subcriteria, String propertyName, Object value) throws HibernateException {
        Class entityClass;
        Queryable q;
        if (value instanceof Class && (q = SessionFactoryHelper.findQueryableUsingImports(this.sessionFactory, (entityClass = (Class)value).getName())) != null) {
            Type type = q.getDiscriminatorType();
            String stringValue = q.getDiscriminatorSQLValue();
            if (stringValue != null && stringValue.length() > 2 && stringValue.startsWith("'") && stringValue.endsWith("'")) {
                stringValue = stringValue.substring(1, stringValue.length() - 1);
            }
            if (!(type instanceof StringRepresentableType)) {
                throw new QueryException("Unsupported discriminator type " + type);
            }
            StringRepresentableType nullableType = (StringRepresentableType)((Object)type);
            value = nullableType.fromStringValue(stringValue);
            return new TypedValue(type, value, EntityMode.POJO);
        }
        return new TypedValue(this.getTypeUsingProjection(subcriteria, propertyName), value, EntityMode.POJO);
    }

    private PropertyMapping getPropertyMapping(String entityName) throws MappingException {
        CriteriaInfoProvider info = (CriteriaInfoProvider)this.nameCriteriaInfoMap.get(entityName);
        return info.getPropertyMapping();
    }

    @Override
    public String getEntityName(Criteria subcriteria, String propertyName) {
        String root;
        Criteria crit;
        if (propertyName.indexOf(46) > 0 && (crit = this.getAliasedCriteria(root = StringHelper.root(propertyName))) != null) {
            return this.getEntityName(crit);
        }
        return this.getEntityName(subcriteria);
    }

    @Override
    public String getSQLAlias(Criteria criteria, String propertyName) {
        String root;
        Criteria subcriteria;
        if (propertyName.indexOf(46) > 0 && (subcriteria = this.getAliasedCriteria(root = StringHelper.root(propertyName))) != null) {
            return this.getSQLAlias(subcriteria);
        }
        return this.getSQLAlias(criteria);
    }

    @Override
    public String getPropertyName(String propertyName) {
        String root;
        Criteria crit;
        if (propertyName.indexOf(46) > 0 && (crit = this.getAliasedCriteria(root = StringHelper.root(propertyName))) != null) {
            return propertyName.substring(root.length() + 1);
        }
        return propertyName;
    }

    public String getWithClause(String path) {
        Criterion crit = (Criterion)this.withClauseMap.get(path);
        return crit == null ? null : crit.toSqlString(this.getCriteria(path), this);
    }

    public boolean hasRestriction(String path) {
        CriteriaImpl.Subcriteria crit = (CriteriaImpl.Subcriteria)this.getCriteria(path);
        return crit == null ? false : crit.hasRestriction();
    }
}

