/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.internal;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hibernate.integrator.internal.IntegratorServiceImpl;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.service.BootstrapServiceRegistry;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.spi.ServiceBinding;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceInitiator;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Stoppable;
import org.jboss.logging.Logger;

public class BootstrapServiceRegistryImpl
implements ServiceRegistryImplementor,
BootstrapServiceRegistry,
ServiceBinding.ServiceLifecycleOwner {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)BootstrapServiceRegistryImpl.class.getName());
    private static final LinkedHashSet<Integrator> NO_INTEGRATORS = new LinkedHashSet();
    private final boolean autoCloseRegistry;
    private boolean active = true;
    private final ServiceBinding<ClassLoaderService> classLoaderServiceBinding;
    private final ServiceBinding<IntegratorService> integratorServiceBinding;
    private Set<ServiceRegistryImplementor> childRegistries;

    public BootstrapServiceRegistryImpl() {
        this((ClassLoaderService)new ClassLoaderServiceImpl(), NO_INTEGRATORS);
    }

    public BootstrapServiceRegistryImpl(ClassLoaderService classLoaderService, IntegratorService integratorService) {
        this(true, classLoaderService, integratorService);
    }

    public BootstrapServiceRegistryImpl(boolean autoCloseRegistry, ClassLoaderService classLoaderService, IntegratorService integratorService) {
        this.autoCloseRegistry = autoCloseRegistry;
        this.classLoaderServiceBinding = new ServiceBinding<ClassLoaderService>(this, ClassLoaderService.class, classLoaderService);
        this.integratorServiceBinding = new ServiceBinding<IntegratorService>(this, IntegratorService.class, integratorService);
    }

    public BootstrapServiceRegistryImpl(ClassLoaderService classLoaderService, LinkedHashSet<Integrator> providedIntegrators) {
        this(true, classLoaderService, new IntegratorServiceImpl(providedIntegrators, classLoaderService));
    }

    @Override
    public <R extends Service> R getService(Class<R> serviceRole) {
        ServiceBinding<R> binding = this.locateServiceBinding(serviceRole);
        return binding == null ? null : (R)binding.getService();
    }

    @Override
    public <R extends Service> ServiceBinding<R> locateServiceBinding(Class<R> serviceRole) {
        if (ClassLoaderService.class.equals(serviceRole)) {
            return this.classLoaderServiceBinding;
        }
        if (IntegratorService.class.equals(serviceRole)) {
            return this.integratorServiceBinding;
        }
        return null;
    }

    @Override
    public void destroy() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.destroy(this.classLoaderServiceBinding);
        this.destroy(this.integratorServiceBinding);
    }

    public boolean isActive() {
        return this.active;
    }

    private void destroy(ServiceBinding serviceBinding) {
        serviceBinding.getLifecycleOwner().stopService(serviceBinding);
    }

    @Override
    public ServiceRegistry getParentServiceRegistry() {
        return null;
    }

    @Override
    public <R extends Service> R initiateService(ServiceInitiator<R> serviceInitiator) {
        throw new ServiceException("Boot-strap registry should only contain provided services");
    }

    @Override
    public <R extends Service> void configureService(ServiceBinding<R> binding) {
        throw new ServiceException("Boot-strap registry should only contain provided services");
    }

    @Override
    public <R extends Service> void injectDependencies(ServiceBinding<R> binding) {
        throw new ServiceException("Boot-strap registry should only contain provided services");
    }

    @Override
    public <R extends Service> void startService(ServiceBinding<R> binding) {
        throw new ServiceException("Boot-strap registry should only contain provided services");
    }

    @Override
    public <R extends Service> void stopService(ServiceBinding<R> binding) {
        R service = binding.getService();
        if (Stoppable.class.isInstance(service)) {
            try {
                ((Stoppable)service).stop();
            }
            catch (Exception e) {
                LOG.unableToStopService(service.getClass(), e.toString());
            }
        }
    }

    @Override
    public void registerChild(ServiceRegistryImplementor child) {
        if (this.childRegistries == null) {
            this.childRegistries = new HashSet<ServiceRegistryImplementor>();
        }
        if (!this.childRegistries.add(child)) {
            LOG.warnf("Child ServiceRegistry [%s] was already registered; this will end badly later...", child);
        }
    }

    @Override
    public void deRegisterChild(ServiceRegistryImplementor child) {
        if (this.childRegistries == null) {
            throw new IllegalStateException("No child ServiceRegistry registrations found");
        }
        this.childRegistries.remove(child);
        if (this.childRegistries.isEmpty()) {
            if (this.autoCloseRegistry) {
                LOG.debug("Implicitly destroying Boot-strap registry on de-registration of all child ServiceRegistries");
                this.destroy();
            } else {
                LOG.debug("Skipping implicitly destroying Boot-strap registry on de-registration of all child ServiceRegistries");
            }
        }
    }
}

