/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.spi;

import java.io.Serializable;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.compare.EqualsHelper;
import org.hibernate.type.Type;

public class CacheKey
implements Serializable {
    private final Serializable key;
    private final Type type;
    private final int hashCode;

    public CacheKey(Serializable id, Type type, String entityOrRoleName, SessionFactoryImplementor factory) {
        this(id, type, entityOrRoleName, factory, null);
    }

    protected CacheKey(Serializable id, Type type, String entityOrRoleName, SessionFactoryImplementor factory, String tenantId) {
        this.key = id;
        this.type = type;
        this.hashCode = this.calculateHashCode(type, factory, tenantId);
    }

    private int calculateHashCode(Type type, SessionFactoryImplementor factory, String tenantId) {
        int result = type.getHashCode(this.key, factory);
        result = 31 * result + (tenantId != null ? tenantId.hashCode() : 0);
        return result;
    }

    public Serializable getKey() {
        return this.key;
    }

    public String getTenantId() {
        return null;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.hashCode != other.hashCode() || !(other instanceof CacheKey)) {
            return false;
        }
        CacheKey that = (CacheKey)other;
        return EqualsHelper.equals(this.getTenantId(), that.getTenantId()) && this.type.isEqual(this.key, that.key);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

