/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.hibernate.property.access.internal.PropertyAccessMixedImpl;
import org.hibernate.property.access.spi.EnhancedSetterImpl;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.property.access.spi.SetterFieldImpl;

public class PropertyAccessEnhancedImpl
extends PropertyAccessMixedImpl {
    public PropertyAccessEnhancedImpl(PropertyAccessStrategy strategy, Class containerJavaType, String propertyName) {
        super(strategy, containerJavaType, propertyName);
    }

    @Override
    protected Setter fieldSetter(Class<?> containerJavaType, String propertyName, Field field) {
        return PropertyAccessEnhancedImpl.resolveEnhancedSetterForField(containerJavaType, propertyName, field);
    }

    private static Setter resolveEnhancedSetterForField(Class<?> containerClass, String propertyName, Field field) {
        try {
            String enhancedSetterName = "$$_hibernate_write_" + propertyName;
            Method enhancedSetter = containerClass.getDeclaredMethod(enhancedSetterName, field.getType());
            enhancedSetter.setAccessible(true);
            return new EnhancedSetterImpl(containerClass, propertyName, enhancedSetter);
        }
        catch (NoSuchMethodException e) {
            return new SetterFieldImpl(containerClass, propertyName, field);
        }
    }
}

