/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal.exec;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.tool.schema.internal.exec.GenerationTarget;
import org.hibernate.tool.schema.internal.exec.JdbcConnectionContext;
import org.hibernate.tool.schema.spi.CommandAcceptanceException;
import org.hibernate.tool.schema.spi.SchemaManagementException;

public class GenerationTargetToDatabase
implements GenerationTarget {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(GenerationTargetToDatabase.class);
    private final SqlExceptionHelper sqlExceptionHelper;
    private final JdbcConnectionContext jdbcConnectionContext;
    private Statement jdbcStatement;

    public GenerationTargetToDatabase(JdbcConnectionContext jdbcConnectionContext) {
        this(jdbcConnectionContext, new SqlExceptionHelper(true));
    }

    public GenerationTargetToDatabase(JdbcConnectionContext jdbcConnectionContext, SqlExceptionHelper sqlExceptionHelper) {
        this.jdbcConnectionContext = jdbcConnectionContext;
        this.sqlExceptionHelper = sqlExceptionHelper;
    }

    @Override
    public void prepare() {
    }

    @Override
    public void accept(String command) {
        try {
            this.jdbcConnectionContext.logSqlStatement(command);
            Statement jdbcStatement = this.jdbcStatement();
            jdbcStatement.execute(command);
            try {
                SQLWarning warnings = jdbcStatement.getWarnings();
                if (warnings != null) {
                    this.sqlExceptionHelper.logAndClearWarnings(jdbcStatement);
                }
            }
            catch (SQLException e) {
                log.unableToLogSqlWarnings(e);
            }
        }
        catch (SQLException e) {
            throw new CommandAcceptanceException("Unable to execute command [" + command + "]", e);
        }
    }

    protected Statement jdbcStatement() {
        if (this.jdbcStatement == null) {
            try {
                this.jdbcStatement = this.jdbcConnectionContext.getConnection().createStatement();
            }
            catch (SQLException e) {
                throw new SchemaManagementException("Unable to create JDBC Statement for schema management target", e);
            }
        }
        return this.jdbcStatement;
    }

    @Override
    public void release() {
        if (this.jdbcStatement != null) {
            try {
                this.jdbcStatement.close();
            }
            catch (SQLException e) {
                log.debug("Unable to close JDBC statement afterQuery JPA schema generation : " + e.toString());
            }
        }
        this.jdbcStatement = null;
        this.jdbcConnectionContext.release();
    }
}

