/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.path;

import java.io.Serializable;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.PluralAttribute;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.PathSource;
import org.hibernate.ejb.criteria.path.AbstractPathImpl;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.collection.CollectionPersister;

public class PluralAttributePath<X>
extends AbstractPathImpl<X>
implements Serializable {
    private final PluralAttribute<?, X, ?> attribute;
    private final CollectionPersister persister;

    public PluralAttributePath(CriteriaBuilderImpl criteriaBuilder, PathSource source, PluralAttribute<?, X, ?> attribute) {
        super(criteriaBuilder, attribute.getJavaType(), source);
        this.attribute = attribute;
        this.persister = PluralAttributePath.resolvePersister(criteriaBuilder, attribute);
    }

    private static CollectionPersister resolvePersister(CriteriaBuilderImpl criteriaBuilder, PluralAttribute attribute) {
        SessionFactoryImplementor sfi = (SessionFactoryImplementor)criteriaBuilder.getEntityManagerFactory().getSessionFactory();
        return sfi.getCollectionPersister(PluralAttributePath.resolveRole(attribute));
    }

    private static String resolveRole(PluralAttribute attribute) {
        return attribute.getDeclaringType().getJavaType().getName() + '.' + attribute.getName();
    }

    public PluralAttribute<?, X, ?> getAttribute() {
        return this.attribute;
    }

    public CollectionPersister getPersister() {
        return this.persister;
    }

    @Override
    protected boolean canBeDereferenced() {
        return false;
    }

    @Override
    protected Attribute locateAttributeInternal(String attributeName) {
        throw new IllegalArgumentException("Plural attribute paths cannot be further dereferenced");
    }

    public Bindable<X> getModel() {
        return null;
    }
}

