/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import java.util.Iterator;
import java.util.Locale;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;
import org.hibernate.MappingException;
import org.hibernate.boot.Metadata;
import org.hibernate.envers.ModificationStore;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.envers.configuration.internal.metadata.AuditMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.MetadataTools;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.entities.IdMappingData;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.SimpleMapperBuilder;
import org.hibernate.envers.internal.entities.mapper.id.AbstractIdMapper;
import org.hibernate.envers.internal.entities.mapper.id.EmbeddedIdMapper;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.entities.mapper.id.MultipleIdMapper;
import org.hibernate.envers.internal.entities.mapper.id.SimpleIdMapperBuilder;
import org.hibernate.envers.internal.entities.mapper.id.SingleIdMapper;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.Type;

public final class IdMetadataGenerator {
    private final AuditMetadataGenerator mainGenerator;

    IdMetadataGenerator(AuditMetadataGenerator auditMetadataGenerator) {
        this.mainGenerator = auditMetadataGenerator;
    }

    private Class<?> loadClass(Component component) {
        String className = component.getComponentClassName();
        return ReflectionTools.loadClass(className, this.mainGenerator.getClassLoaderService());
    }

    private static boolean isSameType(Property left, Property right) {
        return left.getType().getName().equals(right.getType().getName());
    }

    private boolean addIdProperty(Element parent, boolean key, SimpleIdMapperBuilder mapper, Property mappedProperty, Property virtualProperty) {
        if ("_identifierMapper".equals(mappedProperty.getName())) {
            return false;
        }
        PropertyAuditingData propertyAuditingData = this.getIdPersistentPropertyAuditingData(mappedProperty);
        if (ManyToOneType.class.isInstance(mappedProperty.getType())) {
            boolean added = this.addManyToOne(parent, propertyAuditingData, mappedProperty.getValue(), mapper);
            if (added && mapper != null) {
                if (virtualProperty != null && !IdMetadataGenerator.isSameType(mappedProperty, virtualProperty)) {
                    Type valueType = mappedProperty.getType();
                    Type virtualValueType = virtualProperty.getType();
                    mapper.add(propertyAuditingData.resolvePropertyData(valueType, virtualValueType));
                } else {
                    mapper.add(propertyAuditingData.resolvePropertyData(mappedProperty.getType()));
                }
            }
            return added;
        }
        return this.addBasic(parent, propertyAuditingData, mappedProperty.getValue(), mapper, key);
    }

    private boolean addIdProperties(Element parent, Component component, Component virtualComponent, SimpleIdMapperBuilder mapper, boolean key, boolean audited) {
        Iterator properties = component.getPropertyIterator();
        while (properties.hasNext()) {
            Property virtualProperty;
            Property property = (Property)properties.next();
            if (this.addIdProperty(parent, key, mapper, property, virtualProperty = virtualComponent != null ? virtualComponent.getProperty(property.getName()) : null)) continue;
            if (audited) {
                throw new MappingException(String.format(Locale.ROOT, "Type not supported: %s", property.getType().getClass().getName()));
            }
            return false;
        }
        return true;
    }

    public void generateSecondPass(String entityName, PersistentClass persistentClass) {
        Component identifierMapper = persistentClass.getIdentifierMapper();
        Property identifierProperty = persistentClass.getIdentifierProperty();
        if (identifierMapper != null) {
            this.generateSecondPass(entityName, identifierMapper);
        } else if (identifierProperty != null && identifierProperty.isComposite()) {
            Component component = (Component)identifierProperty.getValue();
            this.generateSecondPass(entityName, component);
        }
    }

    private void generateSecondPass(String entityName, Component component) {
        Iterator properties = component.getPropertyIterator();
        while (properties.hasNext()) {
            IdMapper relMapper;
            Property property = (Property)properties.next();
            if (!(property.getValue() instanceof ToOne)) continue;
            PropertyAuditingData propertyData = this.getIdPersistentPropertyAuditingData(property);
            String referencedEntityName = ((ToOne)property.getValue()).getReferencedEntityName();
            String prefix = this.mainGenerator.getVerEntCfg().getOriginalIdPropName() + "." + propertyData.getName();
            if (this.mainGenerator.getEntitiesConfigurations().containsKey(referencedEntityName)) {
                relMapper = this.mainGenerator.getEntitiesConfigurations().get(referencedEntityName).getIdMapper();
            } else if (this.mainGenerator.getNotAuditedEntitiesConfigurations().containsKey(referencedEntityName)) {
                relMapper = this.mainGenerator.getNotAuditedEntitiesConfigurations().get(referencedEntityName).getIdMapper();
            } else {
                throw new MappingException("Unable to locate entity configuration for [" + referencedEntityName + "]");
            }
            IdMapper prefixedMapper = relMapper.prefixMappedProperties(prefix + ".");
            this.mainGenerator.getEntitiesConfigurations().get(entityName).addToOneRelation(prefix, referencedEntityName, prefixedMapper, true, false);
        }
    }

    IdMappingData addId(PersistentClass pc, boolean audited) {
        AbstractIdMapper mapper;
        DefaultElement relIdMapping = new DefaultElement("properties");
        DefaultElement origIdMapping = new DefaultElement("composite-id");
        Property idProp = pc.getIdentifierProperty();
        Component idMapper = pc.getIdentifierMapper();
        if (idMapper == null && idProp == null) {
            return null;
        }
        if (idMapper != null) {
            Class<?> componentClass = this.loadClass((Component)pc.getIdentifier());
            Component virtualComponent = (Component)pc.getIdentifier();
            if (!this.addIdProperties((Element)relIdMapping, idMapper, virtualComponent, (SimpleIdMapperBuilder)((Object)(mapper = new MultipleIdMapper(componentClass, pc.getServiceRegistry()))), false, audited)) {
                return null;
            }
            if (!this.addIdProperties((Element)origIdMapping, idMapper, virtualComponent, null, true, audited)) {
                return null;
            }
        } else if (idProp.isComposite()) {
            Component idComponent = (Component)idProp.getValue();
            Class<?> embeddableClass = this.loadClass(idComponent);
            mapper = new EmbeddedIdMapper(this.getIdPropertyData(idProp), embeddableClass, pc.getServiceRegistry());
            if (!this.addIdProperties((Element)relIdMapping, idComponent, null, (SimpleIdMapperBuilder)((Object)mapper), false, audited)) {
                return null;
            }
            if (!this.addIdProperties((Element)origIdMapping, idComponent, null, null, true, audited)) {
                return null;
            }
        } else {
            mapper = new SingleIdMapper(pc.getServiceRegistry());
            this.mainGenerator.getBasicMetadataGenerator().addBasic((Element)relIdMapping, this.getIdPersistentPropertyAuditingData(idProp), idProp.getValue(), (SimpleMapperBuilder)((Object)mapper), true, false);
            this.mainGenerator.getBasicMetadataGenerator().addBasic((Element)origIdMapping, this.getIdPersistentPropertyAuditingData(idProp), idProp.getValue(), null, true, true);
        }
        origIdMapping.addAttribute("name", this.mainGenerator.getVerEntCfg().getOriginalIdPropName());
        this.mainGenerator.addRevisionInfoRelation((Element)origIdMapping);
        return new IdMappingData(mapper, (Element)origIdMapping, (Element)relIdMapping);
    }

    private PropertyData getIdPropertyData(Property property) {
        return new PropertyData(property.getName(), property.getName(), property.getPropertyAccessorName(), ModificationStore.FULL);
    }

    private PropertyAuditingData getIdPersistentPropertyAuditingData(Property property) {
        return new PropertyAuditingData(property.getName(), property.getPropertyAccessorName(), ModificationStore.FULL, RelationTargetAuditMode.AUDITED, null, null, false);
    }

    boolean addManyToOne(Element parent, PropertyAuditingData propertyAuditingData, Value value, SimpleMapperBuilder mapper) {
        Type type = value.getType();
        Element manyToOneElement = parent.addElement(mapper != null ? "many-to-one" : "key-many-to-one");
        manyToOneElement.addAttribute("name", propertyAuditingData.getName());
        manyToOneElement.addAttribute("class", type.getName());
        manyToOneElement.addAttribute("foreign-key", "none");
        MetadataTools.addColumns(manyToOneElement, value.getColumnIterator(), (Metadata)this.mainGenerator.getMetadata());
        return true;
    }

    boolean addBasic(Element parent, PropertyAuditingData propertyAuditingData, Value value, SimpleIdMapperBuilder mapper, boolean key) {
        return this.mainGenerator.getBasicMetadataGenerator().addBasic(parent, propertyAuditingData, value, mapper, true, key);
    }
}

