/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.internal.TableInsertStandard;

public class InformixSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public InformixSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    public void visitSelectClause(SelectClause selectClause) {
        this.getClauseStack().push((Object)Clause.SELECT);
        try {
            this.appendSql("select ");
            this.visitSqlSelections(selectClause);
            this.renderVirtualSelections(selectClause);
        }
        finally {
            this.getClauseStack().pop();
        }
    }

    protected void visitSqlSelections(SelectClause selectClause) {
        if (this.supportsSkipFirstClause()) {
            this.renderSkipFirstClause((QuerySpec)this.getQueryPartStack().getCurrent());
        } else {
            this.renderFirstClause((QuerySpec)this.getQueryPartStack().getCurrent());
        }
        if (selectClause.isDistinct()) {
            this.appendSql("distinct ");
        }
        super.visitSqlSelections(selectClause);
    }

    protected boolean needsRowsToSkip() {
        return !this.supportsSkipFirstClause();
    }

    protected void renderFetchPlusOffsetExpression(Expression fetchClauseExpression, Expression offsetClauseExpression, int offset) {
        this.renderFetchPlusOffsetExpressionAsSingleParameter(fetchClauseExpression, offsetClauseExpression, offset);
    }

    protected void renderFetchExpression(Expression fetchExpression) {
        if (this.supportsParameterOffsetFetchExpression()) {
            super.renderFetchExpression(fetchExpression);
        } else {
            this.renderExpressionAsLiteral(fetchExpression, this.getJdbcParameterBindings());
        }
    }

    protected void renderOffsetExpression(Expression offsetExpression) {
        if (this.supportsParameterOffsetFetchExpression()) {
            super.renderOffsetExpression(offsetExpression);
        } else {
            this.renderExpressionAsLiteral(offsetExpression, this.getJdbcParameterBindings());
        }
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!queryPart.isRoot() && queryPart.getOffsetClauseExpression() != null) {
            throw new IllegalArgumentException("Can't emulate offset clause in subquery");
        }
    }

    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonEmulateIntersect(lhs, operator, rhs);
    }

    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("dummy_.x");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS!");
            }
            expression.accept((SqlAstWalker)this);
        }
    }

    protected void renderNull(Literal literal) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.NO_UNTYPED) {
            this.renderCasted((Expression)literal);
        } else {
            int sqlType = literal.getExpressionType().getSingleJdbcMapping().getJdbcType().getJdbcTypeCode();
            String nullString = this.getDialect().getSelectClauseNullString(sqlType, this.getSessionFactory().getTypeConfiguration());
            this.appendSql(nullString);
        }
    }

    protected void renderInsertIntoNoColumns(TableInsertStandard tableInsert) {
        this.renderIntoIntoAndTable(tableInsert);
        this.appendSql("values (0)");
    }

    private boolean supportsParameterOffsetFetchExpression() {
        return this.getDialect().getVersion().isSameOrAfter(11);
    }

    private boolean supportsSkipFirstClause() {
        return this.getDialect().getVersion().isSameOrAfter(11);
    }
}

