/*
 * SPDX-License-Identifier: Apache-2.0
 * Copyright Red Hat Inc. and Hibernate Authors
 */
package org.hibernate.community.dialect.identity;

import org.hibernate.dialect.identity.IdentityColumnSupportImpl;

/**
 * @author Andrea Boriero
 */
public class Teradata14IdentityColumnSupport extends IdentityColumnSupportImpl {

	public static Teradata14IdentityColumnSupport INSTANCE = new Teradata14IdentityColumnSupport();

	@Override
	public boolean supportsIdentityColumns() {
		return true;
	}

	@Override
	public String getIdentityColumnString(int type) {
		return "generated by default as identity not null";
	}

	@Override
	public String getIdentityInsertString() {
		return "null";
	}
}
