/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.NamedAuxiliaryDatabaseObject;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.converter.internal.EnumHelper;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;

public class GaussDBEnumJdbcType
implements JdbcType {
    public static final GaussDBEnumJdbcType INSTANCE = new GaussDBEnumJdbcType();

    public int getJdbcTypeCode() {
        return 1111;
    }

    public int getDefaultSqlTypeCode() {
        return 6001;
    }

    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        Class enumClass = (Class)javaType.getJavaType();
        return (JdbcLiteralFormatter & Serializable)(appender, value, dialect, wrapperOptions) -> {
            appender.appendSql("'");
            appender.appendSql(((Enum)value).name());
            appender.appendSql("'::");
            appender.appendSql(dialect.getEnumTypeDeclaration(enumClass));
        };
    }

    public String getFriendlyName() {
        return "ENUM";
    }

    public String toString() {
        return "EnumTypeDescriptor";
    }

    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            protected void doBindNull(PreparedStatement st, int index, WrapperOptions options) throws SQLException {
                st.setNull(index, 1111);
            }

            protected void doBindNull(CallableStatement st, String name, WrapperOptions options) throws SQLException {
                st.setNull(name, 1111);
            }

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setObject(index, this.getJavaType().unwrap(value, String.class, options), 1111);
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setObject(name, this.getJavaType().unwrap(value, String.class, options), 1111);
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(rs.getObject(paramIndex), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(statement.getObject(index), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(statement.getObject(name), options);
            }
        };
    }

    public void addAuxiliaryDatabaseObjects(JavaType<?> javaType, BasicValueConverter<?, ?> valueConverter, Size columnSize, Database database, JdbcTypeIndicators context) {
        Object[] enumeratedValues;
        Class enumClass = (Class)javaType.getJavaType();
        Object[] objectArray = enumeratedValues = valueConverter == null ? EnumHelper.getEnumeratedValues((Class)enumClass) : EnumHelper.getEnumeratedValues((Class)enumClass, valueConverter);
        if (this.getDefaultSqlTypeCode() == 6001) {
            Arrays.sort(enumeratedValues);
        }
        Dialect dialect = database.getDialect();
        String[] create = dialect.getCreateEnumTypeCommand(javaType.getJavaTypeClass().getSimpleName(), (String[])enumeratedValues);
        String[] drop = dialect.getDropEnumTypeCommand(enumClass);
        if (create != null && create.length > 0) {
            database.addAuxiliaryDatabaseObject((AuxiliaryDatabaseObject)new NamedAuxiliaryDatabaseObject(enumClass.getSimpleName(), database.getDefaultNamespace(), create, drop, Collections.emptySet(), true));
        }
    }
}

