/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.GenerationType;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Timeout;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.QueryTimeoutException;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.community.dialect.GaussDBArrayJdbcTypeConstructor;
import org.hibernate.community.dialect.GaussDBCallableStatementSupport;
import org.hibernate.community.dialect.GaussDBCastingInetJdbcType;
import org.hibernate.community.dialect.GaussDBCastingIntervalSecondJdbcType;
import org.hibernate.community.dialect.GaussDBCastingJsonArrayJdbcTypeConstructor;
import org.hibernate.community.dialect.GaussDBCastingJsonJdbcType;
import org.hibernate.community.dialect.GaussDBEnumJdbcType;
import org.hibernate.community.dialect.GaussDBFunctionRegistry;
import org.hibernate.community.dialect.GaussDBOrdinalEnumJdbcType;
import org.hibernate.community.dialect.GaussDBSqlAstTranslator;
import org.hibernate.community.dialect.GaussDBStructuredJdbcType;
import org.hibernate.community.dialect.GaussDBUUIDJdbcType;
import org.hibernate.community.dialect.identity.GaussDBIdentityColumnSupport;
import org.hibernate.community.dialect.lock.internal.GaussDBLockingSupport;
import org.hibernate.community.dialect.sequence.GaussDBSequenceSupport;
import org.hibernate.dialect.BooleanDecoder;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupportImpl;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.SelectItemReferenceStrategy;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitLimitHandler;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.unique.CreateTableUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.SemanticException;
import org.hibernate.query.common.FetchClauseType;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.mutation.internal.cte.CteInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.cte.CteMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.internal.OptionalTableUpdate;
import org.hibernate.sql.model.jdbc.OptionalTableUpdateOperation;
import org.hibernate.tool.schema.extract.internal.InformationExtractorPostgreSQLImpl;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.tool.schema.extract.spi.ExtractionContext;
import org.hibernate.tool.schema.extract.spi.InformationExtractor;
import org.hibernate.tool.schema.internal.StandardTableExporter;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.BasicType;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.jdbc.BlobJdbcType;
import org.hibernate.type.descriptor.jdbc.ClobJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeConstructor;
import org.hibernate.type.descriptor.jdbc.ObjectNullAsBinaryTypeJdbcType;
import org.hibernate.type.descriptor.jdbc.SqlTypedJdbcType;
import org.hibernate.type.descriptor.jdbc.XmlJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.internal.ArrayDdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.NamedNativeEnumDdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.NamedNativeOrdinalEnumDdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.Scale6IntervalSecondDdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class GaussDBDialect
extends Dialect {
    protected static final DatabaseVersion MINIMUM_VERSION = DatabaseVersion.make((Integer)2);
    private final UniqueDelegate uniqueDelegate = new CreateTableUniqueDelegate((Dialect)this);
    private final StandardTableExporter gaussDBTableExporter = new StandardTableExporter(this){

        protected void applyAggregateColumnCheck(StringBuilder buf, AggregateColumn aggregateColumn) {
            JdbcType jdbcType = aggregateColumn.getType().getJdbcType();
            if (jdbcType.isXml()) {
                return;
            }
            super.applyAggregateColumnCheck(buf, aggregateColumn);
        }
    };
    private final OptionalTableUpdateStrategy optionalTableUpdateStrategy;
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        String sqlState = JdbcExceptionHelper.extractSqlState((SQLException)sqle);
        if (sqlState != null) {
            int state;
            try {
                state = Integer.parseInt(sqlState);
            }
            catch (NumberFormatException e) {
                state = 23001;
            }
            switch (state) {
                case 23514: {
                    return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"violates check constraint \"", (String)"\"", (String)sqle.getMessage());
                }
                case 23505: {
                    return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"violates unique constraint \"", (String)"\"", (String)sqle.getMessage());
                }
                case 23503: {
                    return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"violates foreign key constraint \"", (String)"\"", (String)sqle.getMessage());
                }
                case 23502: {
                    return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"null value in column \"", (String)"\" violates not-null constraint", (String)sqle.getMessage());
                }
                case 23001: {
                    return null;
                }
            }
        }
        return null;
    });

    public GaussDBDialect() {
        this(MINIMUM_VERSION);
    }

    public GaussDBDialect(DialectResolutionInfo info) {
        this(info.makeCopyOrDefault(MINIMUM_VERSION));
        this.registerKeywords(info);
    }

    public GaussDBDialect(DatabaseVersion version) {
        super(version);
        this.optionalTableUpdateStrategy = GaussDBDialect.determineOptionalTableUpdateStrategy(version);
    }

    private static OptionalTableUpdateStrategy determineOptionalTableUpdateStrategy(DatabaseVersion version) {
        return version.isSameOrAfter(DatabaseVersion.make((Integer)15, (Integer)0)) ? GaussDBDialect::usingMerge : GaussDBDialect::withoutMerge;
    }

    protected DatabaseVersion getMinimumSupportedVersion() {
        return MINIMUM_VERSION;
    }

    public boolean getDefaultNonContextualLobCreation() {
        return true;
    }

    protected String columnType(int sqlTypeCode) {
        return switch (sqlTypeCode) {
            case -6 -> "smallint";
            case -15 -> this.columnType(1);
            case -9 -> this.columnType(12);
            case 4001, 4002 -> "text";
            case 2011 -> "clob";
            case -3, -2, 4003 -> "bytea";
            case 3003 -> this.columnType(2014);
            default -> super.columnType(sqlTypeCode);
        };
    }

    protected String castType(int sqlTypeCode) {
        return switch (sqlTypeCode) {
            case -15, -9, 1, 12 -> "varchar";
            case 4001, 4002 -> "text";
            case 2011 -> "clob";
            case -3, -2, 4003 -> "bytea";
            default -> super.castType(sqlTypeCode);
        };
    }

    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor((DdlType)new ArrayDdlTypeImpl((Dialect)this, true));
        ddlTypeRegistry.addDescriptor((DdlType)CapacityDependentDdlType.builder((int)6, (String)this.columnType(6), (String)this.castType(6), (Dialect)this).withTypeCapacity(24L, "float4").build());
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(2009, "xml", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3000, "uuid", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3002, "inet", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3200, "geometry", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3250, "geography", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new Scale6IntervalSecondDdlType((Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3001, "jsonb", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new NamedNativeEnumDdlTypeImpl((Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new NamedNativeOrdinalEnumDdlTypeImpl((Dialect)this));
    }

    public int getMaxVarcharLength() {
        return 0xA00000;
    }

    public int getMaxVarcharCapacity() {
        return 0x3FFFFF9F;
    }

    public int getMaxVarbinaryLength() {
        return Integer.MAX_VALUE;
    }

    public int getDefaultStatementBatchSize() {
        return 15;
    }

    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (jdbcTypeCode) {
            case 1111: {
                switch (columnTypeName) {
                    case "uuid": {
                        jdbcTypeCode = 3000;
                        break;
                    }
                    case "json": 
                    case "jsonb": {
                        jdbcTypeCode = 3001;
                        break;
                    }
                    case "xml": {
                        jdbcTypeCode = 2009;
                        break;
                    }
                    case "inet": {
                        jdbcTypeCode = 3002;
                        break;
                    }
                    case "geometry": {
                        jdbcTypeCode = 3200;
                        break;
                    }
                    case "geography": {
                        jdbcTypeCode = 3250;
                    }
                }
                break;
            }
            case 92: {
                if (!"timetz".equals(columnTypeName)) break;
                jdbcTypeCode = 3007;
                break;
            }
            case 93: {
                if (!"timestamptz".equals(columnTypeName)) break;
                jdbcTypeCode = 3003;
                break;
            }
            case 2003: {
                if (columnTypeName.charAt(0) != '_') break;
                String componentTypeName = columnTypeName.substring(1);
                Integer sqlTypeCode = this.resolveSqlTypeCode(componentTypeName, jdbcTypeRegistry.getTypeConfiguration());
                if (sqlTypeCode != null) {
                    return jdbcTypeRegistry.resolveTypeConstructorDescriptor(jdbcTypeCode, jdbcTypeRegistry.getDescriptor(sqlTypeCode.intValue()), ColumnTypeInformation.EMPTY);
                }
                SqlTypedJdbcType elementDescriptor = jdbcTypeRegistry.findSqlTypedDescriptor(componentTypeName);
                if (elementDescriptor == null) break;
                return jdbcTypeRegistry.resolveTypeConstructorDescriptor(jdbcTypeCode, (JdbcType)elementDescriptor, ColumnTypeInformation.EMPTY);
            }
            case 2002: {
                SqlTypedJdbcType descriptor = jdbcTypeRegistry.findSqlTypedDescriptor(columnTypeName.substring(columnTypeName.indexOf(46) + 1));
                if (descriptor == null) break;
                return descriptor;
            }
        }
        return jdbcTypeRegistry.getDescriptor(jdbcTypeCode);
    }

    protected Integer resolveSqlTypeCode(String columnTypeName, TypeConfiguration typeConfiguration) {
        return switch (columnTypeName) {
            case "bool" -> 16;
            case "float4" -> 7;
            case "float8" -> 8;
            case "int2" -> 5;
            case "int4" -> 4;
            case "int8" -> -5;
            default -> super.resolveSqlTypeCode(columnTypeName, typeConfiguration);
        };
    }

    public String getEnumTypeDeclaration(String name, String[] values) {
        return name;
    }

    public String[] getCreateEnumTypeCommand(String name, String[] values) {
        StringBuilder type = new StringBuilder();
        type.append("create type ").append(name).append(" as enum (");
        String separator = "";
        for (String value : values) {
            type.append(separator).append('\'').append(value).append('\'');
            separator = ",";
        }
        type.append(')');
        String cast1 = "create cast (varchar as " + name + ") with inout as implicit";
        String cast2 = "create cast (" + name + " as varchar) with inout as implicit";
        return new String[]{type.toString(), cast1, cast2};
    }

    public String[] getDropEnumTypeCommand(String name) {
        return new String[]{"drop type if exists " + name + " cascade"};
    }

    public String currentTime() {
        return "localtime";
    }

    public String currentTimestamp() {
        return "localtimestamp";
    }

    public String currentTimestampWithTimeZone() {
        return "current_timestamp";
    }

    public String extractPattern(TemporalUnit unit) {
        return switch (unit) {
            case TemporalUnit.DAY_OF_WEEK -> "(" + super.extractPattern(unit) + "+1)";
            default -> super.extractPattern(unit);
        };
    }

    public String castPattern(CastType from, CastType to) {
        if (from == CastType.STRING && to == CastType.BOOLEAN) {
            return "cast(?1 as ?2)";
        }
        if (to == CastType.STRING) {
            switch (from) {
                case BOOLEAN: 
                case INTEGER_BOOLEAN: 
                case TF_BOOLEAN: 
                case YN_BOOLEAN: {
                    return BooleanDecoder.toString((CastType)from);
                }
                case DATE: {
                    return "to_char(?1,'YYYY-MM-DD')";
                }
                case TIME: {
                    return "cast(?1 as ?2)";
                }
                case TIMESTAMP: {
                    return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF9')";
                }
                case OFFSET_TIMESTAMP: {
                    return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF9TZH:TZM')";
                }
                case ZONE_TIMESTAMP: {
                    return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF9 TZR')";
                }
            }
        }
        return super.castPattern(from, to);
    }

    public long getFractionalSecondPrecisionInNanos() {
        return 1000000000L;
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        return intervalType != null ? "(?2+?3)" : "cast(?3+" + GaussDBDialect.intervalPattern(unit) + " as " + temporalType.name().toLowerCase() + ")";
    }

    private static String intervalPattern(TemporalUnit unit) {
        return switch (unit) {
            case TemporalUnit.NANOSECOND -> "(?2)/1e3*interval '1 microsecond'";
            case TemporalUnit.NATIVE -> "(?2)*interval '1 second'";
            case TemporalUnit.QUARTER -> "(?2)*interval '3 month'";
            case TemporalUnit.WEEK -> "(?2)*interval '7 day'";
            default -> "(?2)*interval '1 " + String.valueOf(unit) + "'";
        };
    }

    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        if (unit == null) {
            return "(?3-?2)";
        }
        return switch (unit) {
            case TemporalUnit.YEAR -> "extract(year from ?3-?2)";
            case TemporalUnit.QUARTER -> "(extract(year from ?3-?2)*4+extract(month from ?3-?2)/3)";
            case TemporalUnit.MONTH -> "(extract(year from ?3-?2)*12+extract(month from ?3-?2))";
            case TemporalUnit.WEEK -> "(extract(day from ?3-?2)/7)";
            case TemporalUnit.DAY -> "extract(day from ?3-?2)";
            case TemporalUnit.NANOSECOND, TemporalUnit.NATIVE, TemporalUnit.HOUR, TemporalUnit.MINUTE, TemporalUnit.SECOND -> "extract(epoch from ?3-?2)" + TemporalUnit.EPOCH.conversionFactor(unit, (Dialect)this);
            default -> throw new SemanticException("Unrecognized field: " + String.valueOf(unit));
        };
    }

    public TimeZoneSupport getTimeZoneSupport() {
        return TimeZoneSupport.NORMALIZE;
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        GaussDBFunctionRegistry functionRegistry = new GaussDBFunctionRegistry(functionContributions);
        functionRegistry.register();
    }

    public @Nullable String getDefaultOrdinalityColumnName() {
        return "ordinality";
    }

    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.SCHEMA;
    }

    public String getCurrentSchemaCommand() {
        return "select current_schema()";
    }

    public boolean supportsDistinctFromPredicate() {
        return true;
    }

    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    public boolean supportsIfExistsBeforeTypeName() {
        return true;
    }

    public boolean supportsIfExistsBeforeConstraintName() {
        return true;
    }

    public boolean supportsIfExistsAfterAlterTable() {
        return true;
    }

    public String getBeforeDropStatement() {
        return "set client_min_messages = WARNING";
    }

    public String getAlterColumnTypeString(String columnName, String columnType, String columnDefinition) {
        return "alter column " + columnName + " set data type " + columnType;
    }

    public boolean supportsAlterColumnType() {
        return true;
    }

    public boolean supportsValuesList() {
        return true;
    }

    public boolean supportsPartitionBy() {
        return true;
    }

    public boolean supportsNonQueryWithCTE() {
        return true;
    }

    public boolean supportsConflictClauseForInsertCTE() {
        return true;
    }

    public SequenceSupport getSequenceSupport() {
        return GaussDBSequenceSupport.INSTANCE;
    }

    public String getCascadeConstraintsString() {
        return " cascade";
    }

    public String getQuerySequencesString() {
        return "select * from information_schema.sequences";
    }

    public LimitHandler getLimitHandler() {
        return LimitLimitHandler.INSTANCE;
    }

    public String getForUpdateString(String aliases) {
        return this.getForUpdateString() + " of " + aliases;
    }

    public String getForUpdateString(String aliases, LockOptions lockOptions) {
        LockMode lockMode;
        if (aliases.isEmpty()) {
            lockMode = lockOptions.getLockMode();
            for (Map.Entry entry : lockOptions.getAliasSpecificLocks()) {
                if (!((LockMode)entry.getValue()).greaterThan(lockMode)) continue;
                aliases = (String)entry.getKey();
            }
        }
        if ((lockMode = lockOptions.getAliasSpecificLockMode(aliases)) == null) {
            lockMode = lockOptions.getLockMode();
        }
        return switch (lockMode) {
            case LockMode.PESSIMISTIC_READ -> this.getReadLockString(aliases, lockOptions.getTimeOut());
            case LockMode.PESSIMISTIC_WRITE -> this.getWriteLockString(aliases, lockOptions.getTimeOut());
            case LockMode.UPGRADE_NOWAIT, LockMode.PESSIMISTIC_FORCE_INCREMENT -> this.getForUpdateNowaitString(aliases);
            case LockMode.UPGRADE_SKIPLOCKED -> this.getForUpdateSkipLockedString(aliases);
            default -> "";
        };
    }

    public String getNoColumnsInsertString() {
        return "default values";
    }

    public String getCaseInsensitiveLike() {
        return "ilike";
    }

    public boolean supportsCaseInsensitiveLike() {
        return true;
    }

    public GenerationType getNativeValueGenerationStrategy() {
        return GenerationType.SEQUENCE;
    }

    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    public boolean useInputStreamToInsertBlob() {
        return false;
    }

    public boolean useConnectionToCreateLob() {
        return false;
    }

    public String getSelectClauseNullString(int sqlType, TypeConfiguration typeConfiguration) {
        return "cast(null as " + typeConfiguration.getDdlTypeRegistry().getDescriptor(sqlType).getRawTypeName() + ")";
    }

    public String quoteCollation(String collation) {
        return "\"" + collation + "\"";
    }

    public boolean supportsCommentOn() {
        return true;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        return "select now()";
    }

    public boolean supportsTupleCounts() {
        return true;
    }

    public boolean supportsIsTrue() {
        return true;
    }

    public boolean requiresParensForTupleDistinctCounts() {
        return true;
    }

    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        appender.appendSql(bool);
    }

    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        if (dbMetaData == null) {
            builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.LOWER);
            builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        }
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new CteMutationStrategy(rootEntityDescriptor, runtimeModelCreationContext);
    }

    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new CteInsertStrategy(rootEntityDescriptor, runtimeModelCreationContext);
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new GaussDBSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            String sqlState = JdbcExceptionHelper.extractSqlState((SQLException)sqlException);
            if (sqlState != null) {
                switch (sqlState) {
                    case "40P01": {
                        return new LockAcquisitionException(message, sqlException, sql);
                    }
                    case "55P03": {
                        return new LockTimeoutException(message, sqlException, sql);
                    }
                    case "57014": {
                        return new QueryTimeoutException(message, sqlException, sql);
                    }
                }
            }
            return null;
        };
    }

    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        statement.registerOutParameter(col++, 1111);
        return col;
    }

    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        ps.execute();
        return (ResultSet)ps.getObject(1);
    }

    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    public SelectItemReferenceStrategy getGroupBySelectItemReferenceStrategy() {
        return SelectItemReferenceStrategy.POSITION;
    }

    public CallableStatementSupport getCallableStatementSupport() {
        return GaussDBCallableStatementSupport.INSTANCE;
    }

    public ResultSet getResultSet(CallableStatement statement, int position) throws SQLException {
        if (position != 1) {
            throw new UnsupportedOperationException("GaussDB only supports REF_CURSOR parameters as the first parameter");
        }
        return (ResultSet)statement.getObject(1);
    }

    public ResultSet getResultSet(CallableStatement statement, String name) throws SQLException {
        throw new UnsupportedOperationException("GaussDB only supports accessing REF_CURSOR parameters by position");
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return GaussDBIdentityColumnSupport.INSTANCE;
    }

    public boolean supportsExpectedLobUsagePattern() {
        return false;
    }

    public NationalizationSupport getNationalizationSupport() {
        return NationalizationSupport.IMPLICIT;
    }

    public int getMaxIdentifierLength() {
        return 63;
    }

    public boolean supportsStandardArrays() {
        return true;
    }

    public boolean supportsJdbcConnectionLobCreation(DatabaseMetaData databaseMetaData) {
        return false;
    }

    public boolean supportsMaterializedLobAccess() {
        return false;
    }

    public boolean supportsTemporalLiteralOffset() {
        return true;
    }

    public void appendDatetimeFormat(SqlAppender appender, String format) {
        throw new UnsupportedOperationException("GaussDB not support datetime format yet");
    }

    public String translateExtractField(TemporalUnit unit) {
        return switch (unit) {
            case TemporalUnit.DAY_OF_MONTH -> "day";
            case TemporalUnit.DAY_OF_YEAR -> "doy";
            case TemporalUnit.DAY_OF_WEEK -> "dow";
            default -> super.translateExtractField(unit);
        };
    }

    public AggregateSupport getAggregateSupport() {
        return null;
    }

    public void appendBinaryLiteral(SqlAppender appender, byte[] bytes) {
        appender.appendSql("bytea '\\x");
        PrimitiveByteArrayJavaType.INSTANCE.appendString(appender, bytes);
        appender.appendSql('\'');
    }

    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (TemporalAccessor)temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                if (this.supportsTemporalLiteralOffset() && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                    appender.appendSql("time with time zone '");
                    DateTimeUtils.appendAsTime((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)true, (TimeZone)jdbcTimeZone);
                } else {
                    appender.appendSql("time '");
                    DateTimeUtils.appendAsLocalTime((SqlAppender)appender, (TemporalAccessor)temporalAccessor);
                }
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                if (this.supportsTemporalLiteralOffset() && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                    appender.appendSql("timestamp with time zone '");
                    DateTimeUtils.appendAsTimestampWithMicros((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)true, (TimeZone)jdbcTimeZone);
                    appender.appendSql('\'');
                    break;
                }
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithMicros((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)false, (TimeZone)jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (Date)date);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time with time zone '");
                DateTimeUtils.appendAsTime((SqlAppender)appender, (Date)date, (TimeZone)jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithMicros((SqlAppender)appender, (Date)date, (TimeZone)jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (Calendar)calendar);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time with time zone '");
                DateTimeUtils.appendAsTime((SqlAppender)appender, (Calendar)calendar, (TimeZone)jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithMillis((SqlAppender)appender, (Calendar)calendar, (TimeZone)jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private String withTimeout(String lockString, Timeout timeout) {
        return switch (timeout.milliseconds()) {
            case 0 -> {
                if (this.supportsNoWait()) {
                    yield lockString + " nowait";
                }
                yield lockString;
            }
            case -2 -> {
                if (this.supportsSkipLocked()) {
                    yield lockString + " skip locked";
                }
                yield lockString;
            }
            default -> lockString;
        };
    }

    public String getWriteLockString(Timeout timeout) {
        return this.withTimeout(this.getForUpdateString(), timeout);
    }

    public String getWriteLockString(String aliases, Timeout timeout) {
        return this.withTimeout(this.getForUpdateString(aliases), timeout);
    }

    public String getReadLockString(Timeout timeout) {
        return this.withTimeout(" for share", timeout);
    }

    public String getReadLockString(String aliases, Timeout timeout) {
        return this.withTimeout(" for share of " + aliases, timeout);
    }

    private String withTimeout(String lockString, int timeout) {
        return switch (timeout) {
            case 0 -> {
                if (this.supportsNoWait()) {
                    yield lockString + " nowait";
                }
                yield lockString;
            }
            case -2 -> {
                if (this.supportsSkipLocked()) {
                    yield lockString + " skip locked";
                }
                yield lockString;
            }
            default -> lockString;
        };
    }

    public String getWriteLockString(int timeout) {
        return this.withTimeout(this.getForUpdateString(), timeout);
    }

    public String getWriteLockString(String aliases, int timeout) {
        return this.withTimeout(this.getForUpdateString(aliases), timeout);
    }

    public String getReadLockString(int timeout) {
        return this.withTimeout(" for share", timeout);
    }

    public String getReadLockString(String aliases, int timeout) {
        return this.withTimeout(" for share of " + aliases, timeout);
    }

    public LockingSupport getLockingSupport() {
        return GaussDBLockingSupport.LOCKING_SUPPORT;
    }

    public String getForUpdateNowaitString() {
        return this.supportsNoWait() ? " for update nowait" : this.getForUpdateString();
    }

    public String getForUpdateNowaitString(String aliases) {
        return this.supportsNoWait() ? " for update of " + aliases + " nowait" : this.getForUpdateString(aliases);
    }

    public String getForUpdateSkipLockedString() {
        return this.supportsSkipLocked() ? " for update skip locked" : this.getForUpdateString();
    }

    public String getForUpdateSkipLockedString(String aliases) {
        return this.supportsSkipLocked() ? " for update of " + aliases + " skip locked" : this.getForUpdateString(aliases);
    }

    public boolean supportsNoWait() {
        return true;
    }

    public boolean supportsWait() {
        return false;
    }

    public boolean supportsSkipLocked() {
        return true;
    }

    public boolean supportsInsertReturning() {
        return true;
    }

    public boolean supportsOffsetInSubquery() {
        return true;
    }

    public boolean supportsWindowFunctions() {
        return true;
    }

    public boolean supportsLateral() {
        return false;
    }

    public boolean supportsRecursiveCTE() {
        return false;
    }

    public boolean supportsOrderByInSubquery() {
        return false;
    }

    public boolean supportsFetchClause(FetchClauseType type) {
        return false;
    }

    public String getForUpdateString() {
        return " for update";
    }

    public boolean supportsFilterClause() {
        return false;
    }

    public FunctionalDependencyAnalysisSupport getFunctionalDependencyAnalysisSupport() {
        return FunctionalDependencyAnalysisSupportImpl.TABLE_REFERENCE;
    }

    public RowLockStrategy getWriteRowLockStrategy() {
        return RowLockStrategy.TABLE;
    }

    public void augmentRecognizedTableTypes(List<String> tableTypesList) {
        super.augmentRecognizedTableTypes(tableTypesList);
        tableTypesList.add("MATERIALIZED VIEW");
        tableTypesList.add("PARTITIONED TABLE");
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        this.contributeGaussDBTypes(typeContributions);
    }

    protected void contributeGaussDBTypes(TypeContributions typeContributions) {
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        jdbcTypeRegistry.addDescriptor(2004, (JdbcType)BlobJdbcType.BLOB_BINDING);
        jdbcTypeRegistry.addDescriptor(2005, (JdbcType)ClobJdbcType.CLOB_BINDING);
        jdbcTypeRegistry.addDescriptor((JdbcType)XmlJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)GaussDBCastingInetJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)GaussDBCastingIntervalSecondJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)GaussDBStructuredJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)GaussDBCastingJsonJdbcType.JSONB_INSTANCE);
        jdbcTypeRegistry.addTypeConstructorIfAbsent((JdbcTypeConstructor)GaussDBCastingJsonArrayJdbcTypeConstructor.JSONB_INSTANCE);
        typeContributions.contributeJdbcType((JdbcType)ObjectNullAsBinaryTypeJdbcType.INSTANCE);
        typeContributions.contributeType((BasicType)new JavaObjectType((JdbcType)ObjectNullAsBinaryTypeJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().getDescriptor(Object.class)));
        jdbcTypeRegistry.addDescriptor((JdbcType)GaussDBEnumJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor((JdbcType)GaussDBOrdinalEnumJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor((JdbcType)GaussDBUUIDJdbcType.INSTANCE);
        jdbcTypeRegistry.addTypeConstructor((JdbcTypeConstructor)GaussDBArrayJdbcTypeConstructor.INSTANCE);
    }

    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    public Exporter<Table> getTableExporter() {
        return this.gaussDBTableExporter;
    }

    public boolean canBatchTruncate() {
        return true;
    }

    public String getQueryHintString(String sql, String hints) {
        return "/*+ " + hints + " */ " + sql;
    }

    public String addSqlHintOrComment(String sql, QueryOptions queryOptions, boolean commentsEnabled) {
        if (commentsEnabled && queryOptions.getComment() != null) {
            sql = this.prependComment(sql, queryOptions.getComment());
        }
        if (queryOptions.getDatabaseHints() != null && !queryOptions.getDatabaseHints().isEmpty()) {
            sql = this.getQueryHintString(sql, queryOptions.getDatabaseHints());
        }
        return sql;
    }

    public MutationOperation createOptionalTableUpdateOperation(EntityMutationTarget mutationTarget, OptionalTableUpdate optionalTableUpdate, SessionFactoryImplementor factory) {
        return this.optionalTableUpdateStrategy.buildMutationOperation(mutationTarget, optionalTableUpdate, factory);
    }

    private static MutationOperation usingMerge(EntityMutationTarget mutationTarget, OptionalTableUpdate optionalTableUpdate, SessionFactoryImplementor factory) {
        GaussDBSqlAstTranslator translator = new GaussDBSqlAstTranslator(factory, (Statement)optionalTableUpdate);
        return translator.createMergeOperation(optionalTableUpdate);
    }

    private static MutationOperation withoutMerge(EntityMutationTarget mutationTarget, OptionalTableUpdate optionalTableUpdate, SessionFactoryImplementor factory) {
        return new OptionalTableUpdateOperation((MutationTarget)mutationTarget, optionalTableUpdate, factory);
    }

    public int getDefaultIntervalSecondScale() {
        return 6;
    }

    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.TABLE_ALIAS;
    }

    public boolean supportsFromClauseInUpdate() {
        return true;
    }

    public boolean supportsBindingNullSqlTypeForSetNull() {
        return true;
    }

    public InformationExtractor getInformationExtractor(ExtractionContext extractionContext) {
        return new InformationExtractorPostgreSQLImpl(extractionContext);
    }

    @FunctionalInterface
    private static interface OptionalTableUpdateStrategy {
        public MutationOperation buildMutationOperation(EntityMutationTarget var1, OptionalTableUpdate var2, SessionFactoryImplementor var3);
    }

    private static class NativeParameterMarkers
    implements ParameterMarkerStrategy {
        public static final NativeParameterMarkers INSTANCE = new NativeParameterMarkers();

        private NativeParameterMarkers() {
        }

        public String createMarker(int position, JdbcType jdbcType) {
            return "$" + position;
        }
    }
}

