/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.net.InetAddress;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class GaussDBCastingInetJdbcType
implements JdbcType {
    public static final GaussDBCastingInetJdbcType INSTANCE = new GaussDBCastingInetJdbcType();

    public void appendWriteExpression(String writeExpression, @Nullable Size size, SqlAppender appender, Dialect dialect) {
        appender.append((CharSequence)"cast(");
        appender.append((CharSequence)writeExpression);
        appender.append((CharSequence)" as inet)");
    }

    public boolean isWriteExpressionTyped(Dialect dialect) {
        return true;
    }

    public int getJdbcTypeCode() {
        return -3;
    }

    public int getDefaultSqlTypeCode() {
        return 3002;
    }

    public String toString() {
        return "InetSecondJdbcType";
    }

    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return null;
    }

    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setString(index, this.getStringValue(value, options));
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setString(name, this.getStringValue(value, options));
            }

            private String getStringValue(X value, WrapperOptions options) {
                return ((InetAddress)this.getJavaType().unwrap(value, InetAddress.class, options)).getHostAddress();
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getObject(rs.getString(paramIndex), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getString(index), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getString(name), options);
            }

            private X getObject(String inetString, WrapperOptions options) throws SQLException {
                if (inetString == null) {
                    return null;
                }
                return this.getJavaType().wrap((Object)inetString, options);
            }
        };
    }
}

