/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.type.AbstractPostgreSQLStructJdbcType;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class GaussDBStructuredJdbcType
extends AbstractPostgreSQLStructJdbcType {
    public static final GaussDBStructuredJdbcType INSTANCE = new GaussDBStructuredJdbcType();

    public GaussDBStructuredJdbcType() {
        this(null, null, null);
    }

    private GaussDBStructuredJdbcType(EmbeddableMappingType embeddableMappingType, String typeName, int[] orderMapping) {
        super(embeddableMappingType, typeName, orderMapping);
    }

    public AggregateJdbcType resolveAggregateJdbcType(EmbeddableMappingType mappingType, String sqlType, RuntimeModelCreationContext creationContext) {
        return new GaussDBStructuredJdbcType(mappingType, sqlType, creationContext.getBootModel().getDatabase().getDefaultNamespace().locateUserDefinedType(Identifier.toIdentifier((String)sqlType)).getOrderMapping());
    }

    public void appendWriteExpression(String writeExpression, @Nullable Size size, SqlAppender appender, Dialect dialect) {
        appender.append((CharSequence)"cast(");
        appender.append((CharSequence)writeExpression);
        appender.append((CharSequence)" as ");
        appender.append((CharSequence)this.getStructTypeName());
        appender.append(')');
    }

    public boolean isWriteExpressionTyped(Dialect dialect) {
        return true;
    }

    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, (JdbcType)this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                String stringValue = ((GaussDBStructuredJdbcType)this.getJdbcType()).toString(value, this.getJavaType(), options);
                st.setString(index, stringValue);
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                String stringValue = ((GaussDBStructuredJdbcType)this.getJdbcType()).toString(value, this.getJavaType(), options);
                st.setString(name, stringValue);
            }

            public Object getBindValue(X value, WrapperOptions options) throws SQLException {
                return ((GaussDBStructuredJdbcType)this.getJdbcType()).getBindValue(value, options);
            }
        };
    }
}

