/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.TimeZone;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.community.dialect.InformixSqlAstTranslator;
import org.hibernate.community.dialect.InformixSqmToSqlAstConverter;
import org.hibernate.community.dialect.function.InformixRegexpLikeFunction;
import org.hibernate.community.dialect.identity.InformixIdentityColumnSupport;
import org.hibernate.community.dialect.pagination.FirstLimitHandler;
import org.hibernate.community.dialect.pagination.SkipFirstLimitHandler;
import org.hibernate.community.dialect.sequence.InformixSequenceSupport;
import org.hibernate.community.dialect.sequence.SequenceInformationExtractorInformixDatabaseImpl;
import org.hibernate.community.dialect.temptable.InformixLocalTemporaryTableStrategy;
import org.hibernate.community.dialect.unique.InformixUniqueDelegate;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.NullOrdering;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.SelectItemReferenceStrategy;
import org.hibernate.dialect.function.CaseLeastGreatestEmulation;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.InsertSubstringOverlayEmulation;
import org.hibernate.dialect.function.TrimFunction;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.lock.internal.LockingSupportSimple;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.dialect.temptable.TemporaryTableStrategy;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.CheckConstraint;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.AfterUseAction;
import org.hibernate.query.sqm.mutation.spi.BeforeUseAction;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.sql.StandardSqmTranslatorFactory;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.tool.schema.internal.StandardForeignKeyExporter;
import org.hibernate.tool.schema.internal.StandardTableExporter;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.BasicType;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.jdbc.ClobJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.ObjectNullAsBinaryTypeJdbcType;
import org.hibernate.type.descriptor.jdbc.VarcharUUIDJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class InformixDialect
extends Dialect {
    private static final DatabaseVersion DEFAULT_VERSION = DatabaseVersion.make((Integer)7, (Integer)0);
    private final UniqueDelegate uniqueDelegate;
    private final LimitHandler limitHandler;
    private final SequenceSupport sequenceSupport;
    private final StandardForeignKeyExporter foreignKeyExporter = new StandardForeignKeyExporter(this){

        public String[] getSqlCreateStrings(ForeignKey foreignKey, Metadata metadata, SqlStringGenerationContext context) {
            String[] results = super.getSqlCreateStrings(foreignKey, metadata, context);
            for (int i = 0; i < results.length; ++i) {
                String result = results[i];
                if (!result.contains(" on delete ")) continue;
                String constraintName = "constraint " + foreignKey.getName();
                results[i] = result.replace(constraintName + " ", "") + " " + constraintName;
            }
            return results;
        }
    };
    private final StandardTableExporter informixTableExporter = new StandardTableExporter(this){

        protected String primaryKeyString(PrimaryKey key) {
            StringBuilder constraint = new StringBuilder();
            constraint.append("primary key (");
            boolean first = true;
            for (Column column : key.getColumns()) {
                if (first) {
                    first = false;
                } else {
                    constraint.append(", ");
                }
                constraint.append(column.getQuotedName(this.dialect));
            }
            constraint.append(')');
            UniqueKey orderingUniqueKey = key.getOrderingUniqueKey();
            if (orderingUniqueKey != null && orderingUniqueKey.isNameExplicit()) {
                constraint.append(" constraint ").append(orderingUniqueKey.getName()).append(' ');
            }
            return constraint.toString();
        }
    };
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        String constraintName;
        switch (JdbcExceptionHelper.extractErrorCode((SQLException)sqle)) {
            case -268: 
            case -239: {
                String string = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"Unique constraint (", (String)") violated.", (String)sqle.getMessage());
                break;
            }
            case -691: {
                String string = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"Missing key in referenced table for referential constraint (", (String)").", (String)sqle.getMessage());
                break;
            }
            case -692: {
                String string = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"Key value for constraint (", (String)") is still being referenced.", (String)sqle.getMessage());
                break;
            }
            case -530: {
                String string = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"Check constraint (", (String)") failed", (String)sqle.getMessage());
                break;
            }
            case -391: {
                String string = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"null into column (", (String)")", (String)sqle.getMessage());
                break;
            }
            default: {
                String string = constraintName = null;
            }
        }
        if (constraintName == null) {
            return null;
        }
        int index = constraintName.indexOf(46);
        return index > 0 ? constraintName.substring(index + 1) : constraintName;
    });

    public InformixDialect(DialectResolutionInfo info) {
        this(info.makeCopyOrDefault(DEFAULT_VERSION));
        this.registerKeywords(info);
    }

    public InformixDialect() {
        this(DEFAULT_VERSION);
    }

    public InformixDialect(DatabaseVersion version) {
        super(version);
        this.uniqueDelegate = new InformixUniqueDelegate(this);
        this.limitHandler = this.getVersion().isBefore(10) ? FirstLimitHandler.INSTANCE : new SkipFirstLimitHandler(this.getVersion().isSameOrAfter(11));
        this.sequenceSupport = new InformixSequenceSupport(this.getVersion().isSameOrAfter(11, 70));
    }

    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -6: {
                return "smallint";
            }
            case 92: {
                return "datetime hour to second";
            }
            case 93: 
            case 2014: {
                return "datetime year to fraction($p)";
            }
            case -3: 
            case -2: 
            case 4003: {
                return "byte";
            }
            case 4001: 
            case 4002: {
                return "text";
            }
            case -9: 
            case 12: {
                return "lvarchar($l)";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor((DdlType)CapacityDependentDdlType.builder((int)6, (String)"float", (Dialect)this).withTypeCapacity(8L, "smallfloat").build());
        ddlTypeRegistry.addDescriptor((DdlType)CapacityDependentDdlType.builder((int)12, (String)this.columnType(4001), (String)"lvarchar", (Dialect)this).withTypeCapacity(255L, "varchar($l)").withTypeCapacity((long)this.getMaxVarcharLength(), this.columnType(12)).build());
        ddlTypeRegistry.addDescriptor((DdlType)CapacityDependentDdlType.builder((int)-9, (String)this.columnType(4002), (String)"nvarchar(255)", (Dialect)this).withTypeCapacity(255L, "nvarchar($l)").withTypeCapacity((long)this.getMaxNVarcharLength(), this.columnType(-9)).build());
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3000, "char(36)", (Dialect)this));
    }

    public boolean useMaterializedLobWhenCapacityExceeded() {
        return false;
    }

    public int getMaxVarbinaryLength() {
        return -1;
    }

    public int getMaxVarcharLength() {
        return 32739;
    }

    public int getDefaultDecimalPrecision() {
        return 32;
    }

    public int getDefaultTimestampPrecision() {
        return 3;
    }

    public boolean doesRoundTemporalOnOverflow() {
        return false;
    }

    public int getFloatPrecision() {
        return 8;
    }

    public int getDoublePrecision() {
        return 16;
    }

    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    public SelectItemReferenceStrategy getGroupBySelectItemReferenceStrategy() {
        return SelectItemReferenceStrategy.POSITION;
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.aggregates((Dialect)this, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        functionFactory.instr();
        functionFactory.substr();
        functionFactory.substringFromFor();
        functionFactory.trunc();
        functionFactory.trim2();
        functionFactory.space();
        functionFactory.reverse();
        functionFactory.octetLength();
        functionFactory.degrees();
        functionFactory.radians();
        functionFactory.sinh();
        functionFactory.tanh();
        functionFactory.cosh();
        functionFactory.moreHyperbolic();
        functionFactory.log10();
        functionFactory.initcap();
        functionFactory.yearMonthDay();
        functionFactory.ceiling_ceil();
        functionFactory.concat_pipeOperator();
        functionFactory.ascii();
        functionFactory.char_chr();
        functionFactory.addMonths();
        functionFactory.monthsBetween();
        functionFactory.stddev();
        functionFactory.variance();
        functionFactory.bitLength_pattern("length(?1)*8");
        functionFactory.varPop_sumCount();
        SqmFunctionRegistry functionRegistry = functionContributions.getFunctionRegistry();
        TypeConfiguration typeConfiguration = functionContributions.getTypeConfiguration();
        BasicType stringBasicType = typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.STRING);
        BasicType booleanBasicType = typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.BOOLEAN);
        functionRegistry.registerAlternateKey("var_samp", "variance");
        if (this.getVersion().isSameOrAfter(12)) {
            functionFactory.locate_charindex();
        }
        if (this.getVersion().isBefore(12, 10)) {
            functionRegistry.register("least", (SqmFunctionDescriptor)new CaseLeastGreatestEmulation(true));
            functionRegistry.register("greatest", (SqmFunctionDescriptor)new CaseLeastGreatestEmulation(false));
        }
        functionRegistry.namedDescriptorBuilder("matches").setInvariantType(stringBasicType).setExactArgumentCount(2).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.impliedOrInvariant((TypeConfiguration)typeConfiguration, (FunctionParameterType)FunctionParameterType.STRING)).setArgumentListSignature("(STRING string, STRING pattern)").register();
        if (this.supportsWindowFunctions()) {
            functionFactory.windowFunctions();
            functionFactory.hypotheticalOrderedSetAggregates();
        }
        functionRegistry.register("overlay", (SqmFunctionDescriptor)new InsertSubstringOverlayEmulation(typeConfiguration, true));
        functionRegistry.namedDescriptorBuilder("coalesce").setMinArgumentCount(1).setArgumentRenderingMode(SqlAstNodeRenderingMode.INLINE_PARAMETERS).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        functionContributions.getFunctionRegistry().register("trim", (SqmFunctionDescriptor)new TrimFunction((Dialect)this, typeConfiguration, SqlAstNodeRenderingMode.NO_UNTYPED));
        functionRegistry.register("regexp_like", (SqmFunctionDescriptor)new InformixRegexpLikeFunction(typeConfiguration));
    }

    public SqmTranslatorFactory getSqmTranslatorFactory() {
        return new StandardSqmTranslatorFactory(){

            public SqmTranslator<SelectStatement> createSelectTranslator(SqmSelectStatement<?> sqmSelectStatement, QueryOptions queryOptions, DomainParameterXref domainParameterXref, QueryParameterBindings domainParameterBindings, LoadQueryInfluencers loadQueryInfluencers, SqlAstCreationContext creationContext, boolean deduplicateSelectionItems) {
                return new InformixSqmToSqlAstConverter((SqmStatement<?>)sqmSelectStatement, queryOptions, domainParameterXref, domainParameterBindings, loadQueryInfluencers, creationContext, deduplicateSelectionItems);
            }
        };
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new InformixSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public String extractPattern(TemporalUnit unit) {
        return switch (unit) {
            case TemporalUnit.SECOND -> {
                if (this.getVersion().isBefore(11, 70)) {
                    yield "to_number(to_char(?2,'%S%F3'))";
                }
                yield "to_number(to_char(?2,'%S.%F3'))";
            }
            case TemporalUnit.MINUTE -> "to_number(to_char(?2,'%M'))";
            case TemporalUnit.HOUR -> "to_number(to_char(?2,'%H'))";
            case TemporalUnit.DAY_OF_WEEK -> "(weekday(?2)+1)";
            case TemporalUnit.DAY_OF_MONTH -> "day(?2)";
            case TemporalUnit.EPOCH -> "(to_number(cast(cast((?2-datetime(1970-1-1) year to day) as interval day(9) to day) as varchar(12)))*86400+to_number(cast(cast((cast(?2 as datetime hour to second)-datetime(00:00:00) hour to second) as interval second(6) to second) as varchar(9))))";
            default -> "?1(?2)";
        };
    }

    public String getAddColumnString() {
        return "add";
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        StringBuilder result = new StringBuilder(30).append(" add constraint foreign key (").append(String.join((CharSequence)", ", foreignKey)).append(") references ").append(referencedTable);
        if (!referencesPrimaryKey) {
            result.append(" (").append(String.join((CharSequence)", ", primaryKey)).append(')');
        }
        result.append(" constraint ").append(constraintName);
        return result.toString();
    }

    public String getAddForeignKeyConstraintString(String constraintName, String foreignKeyDefinition) {
        return " add constraint " + foreignKeyDefinition + " constraint " + constraintName;
    }

    public Exporter<ForeignKey> getForeignKeyExporter() {
        if (this.getVersion().isSameOrAfter(12, 10)) {
            return super.getForeignKeyExporter();
        }
        return this.foreignKeyExporter;
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return " add constraint primary key constraint " + constraintName + " ";
    }

    public String getTruncateTableStatement(String tableName) {
        return super.getTruncateTableStatement(tableName) + " reuse storage" + (this.getVersion().isSameOrAfter(12, 10) ? " keep statistics" : "");
    }

    public SequenceSupport getSequenceSupport() {
        return this.sequenceSupport;
    }

    public String getQuerySequencesString() {
        return "select systables.tabname as sequence_name,syssequences.* from syssequences join systables on syssequences.tabid=systables.tabid where tabtype='Q'";
    }

    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorInformixDatabaseImpl.INSTANCE;
    }

    public NullOrdering getNullOrdering() {
        return NullOrdering.SMALLEST;
    }

    public boolean supportsNullPrecedence() {
        return this.getVersion().isSameOrAfter(12, 10);
    }

    public LimitHandler getLimitHandler() {
        return this.limitHandler;
    }

    public LockingSupport getLockingSupport() {
        return LockingSupportSimple.STANDARD_SUPPORT;
    }

    @Deprecated(forRemoval=true)
    public boolean supportsSkipLocked() {
        return false;
    }

    public boolean supportsIfExistsBeforeTableName() {
        return this.getVersion().isSameOrAfter(11, 70);
    }

    public boolean supportsIfExistsBeforeTypeName() {
        return this.getVersion().isSameOrAfter(11, 70);
    }

    public boolean supportsIfExistsBeforeConstraintName() {
        return this.getVersion().isSameOrAfter(11, 70);
    }

    public boolean supportsNamedColumnCheck() {
        return false;
    }

    public String getCheckConstraintString(CheckConstraint checkConstraint) {
        String constraintName = checkConstraint.getName();
        String constraint = " check (" + checkConstraint.getConstraint() + ")";
        String constraintWithName = StringHelper.isBlank((String)constraintName) ? constraint : constraint + " constraint " + constraintName;
        return this.appendCheckConstraintOptions(checkConstraint, constraintWithName);
    }

    public String getCascadeConstraintsString() {
        return this.getVersion().isSameOrAfter(12, 10) ? " cascade" : "";
    }

    public boolean dropConstraints() {
        return !this.getVersion().isSameOrAfter(12, 10);
    }

    public boolean canDisableConstraints() {
        return true;
    }

    public String getDisableConstraintStatement(String tableName, String name) {
        return "set constraints " + name + " disabled";
    }

    public String getEnableConstraintStatement(String tableName, String name) {
        return "set constraints " + name + " enabled";
    }

    public boolean supportsOrderByInSubquery() {
        return false;
    }

    public boolean supportsWindowFunctions() {
        return this.getVersion().isSameOrAfter(12, 10);
    }

    public boolean supportsLateral() {
        return this.getVersion().isSameOrAfter(12, 10);
    }

    public boolean supportsValuesListForInsert() {
        return false;
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (exception, message, sql) -> switch (JdbcExceptionHelper.extractErrorCode((SQLException)exception)) {
            case -268, -239 -> new ConstraintViolationException(message, exception, sql, ConstraintViolationException.ConstraintKind.UNIQUE, this.getViolatedConstraintNameExtractor().extractConstraintName(exception));
            case -692, -691 -> new ConstraintViolationException(message, exception, sql, ConstraintViolationException.ConstraintKind.FOREIGN_KEY, this.getViolatedConstraintNameExtractor().extractConstraintName(exception));
            case -703, -391 -> new ConstraintViolationException(message, exception, sql, ConstraintViolationException.ConstraintKind.NOT_NULL, this.getViolatedConstraintNameExtractor().extractConstraintName(exception));
            case -530 -> new ConstraintViolationException(message, exception, sql, ConstraintViolationException.ConstraintKind.CHECK, this.getViolatedConstraintNameExtractor().extractConstraintName(exception));
            default -> {
                SQLException cause;
                Throwable patt0$temp = exception.getCause();
                if (patt0$temp instanceof SQLException && (cause = (SQLException)patt0$temp) != exception) {
                    switch (JdbcExceptionHelper.extractErrorCode((SQLException)cause)) {
                        case -154: 
                        case -144: 
                        case -143: 
                        case -134: 
                        case -113: 
                        case -107: {
                            yield new LockAcquisitionException(message, exception, sql);
                        }
                    }
                    yield null;
                }
                yield null;
            }
        };
    }

    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        return "select sysdate" + (this.getVersion().isBefore(12, 10) ? " from informix.systables where tabid=1" : "");
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        return intervalType != null ? "(?2 + ?3)" : "(?3 + " + InformixDialect.intervalPattern(unit, temporalType) + ")";
    }

    private static String intervalPattern(TemporalUnit unit, TemporalType temporalType) {
        return switch (unit) {
            case TemporalUnit.NANOSECOND -> "?2/1e9 * interval (1) second(9) to fraction";
            case TemporalUnit.SECOND, TemporalUnit.NATIVE -> {
                if (temporalType == TemporalType.TIME) {
                    yield "?2 * 1 units second";
                }
                yield "?2 * interval (1) second(9) to fraction";
            }
            case TemporalUnit.QUARTER -> "?2 * 3 units month";
            case TemporalUnit.WEEK -> "?2 * 7 units day";
            default -> "?2 * 1 units " + String.valueOf(unit);
        };
    }

    public long getFractionalSecondPrecisionInNanos() {
        return 1000000000L;
    }

    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        if (unit == null) {
            return "(?3-?2)";
        }
        if (fromTemporalType == TemporalType.DATE && toTemporalType == TemporalType.DATE) {
            return switch (unit) {
                case TemporalUnit.NATIVE -> "to_number(cast(?3-?2 as lvarchar))*86400";
                case TemporalUnit.YEAR, TemporalUnit.MONTH -> "to_number(cast(cast(extend(?3,year to month)-extend(?2,year to month) as interval ?1(9) to ?1) as varchar(12)))";
                case TemporalUnit.DAY -> "to_number(cast(?3-?2 as lvarchar))";
                case TemporalUnit.WEEK -> "floor(to_number(cast(?3-?2 as lvarchar))/7)";
                default -> "to_number(cast(?3-?2 as lvarchar))" + TemporalUnit.DAY.conversionFactor(unit, (Dialect)this);
            };
        }
        return switch (unit) {
            case TemporalUnit.NATIVE -> {
                if (fromTemporalType == TemporalType.TIME) {
                    yield "(mod(to_number(cast(cast(?3-?2 as interval second(6) to second) as varchar(9))),86400)+to_number(cast(cast(?3-?2 as interval fraction to fraction) as varchar(6))))";
                }
                yield "(to_number(cast(cast(?3-?2 as interval day(9) to day) as varchar(12)))*86400+mod(to_number(cast(cast(?3-?2 as interval second(6) to second) as varchar(9))),86400)+to_number(cast(cast(?3-?2 as interval fraction to fraction) as varchar(6))))";
            }
            case TemporalUnit.SECOND -> "to_number(cast(cast(?3-?2 as interval second(9) to fraction) as varchar(15)))";
            case TemporalUnit.NANOSECOND -> "(to_number(cast(cast(?3-?2 as interval second(9) to fraction) as varchar(15)))*1e9)";
            default -> "to_number(cast(cast(?3-?2 as interval ?1(9) to ?1) as varchar(12)))";
        };
    }

    public String castPattern(CastType from, CastType to) {
        if (from == CastType.BOOLEAN) {
            switch (to) {
                case STRING: {
                    return "trim(case ?1 when 't' then 'true' when 'f' then 'false' else null end)";
                }
                case TF_BOOLEAN: {
                    return "upper(cast(?1 as varchar))";
                }
                case YN_BOOLEAN: {
                    return "case ?1 when 't' then 'Y' when 'f' then 'N' else null end";
                }
                case INTEGER_BOOLEAN: {
                    return "case ?1 when 't' then 1 when 'f' then 0 else null end";
                }
            }
        }
        if (from == CastType.STRING && to == CastType.BOOLEAN) {
            return this.buildStringToBooleanCast("'t'", "'f'");
        }
        return super.castPattern(from, to);
    }

    public void appendBinaryLiteral(SqlAppender appender, byte[] bytes) {
        throw new UnsupportedOperationException("Informix does not support binary literals");
    }

    public String getCatalogSeparator() {
        return ":";
    }

    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableMutationStrategy(rootEntityDescriptor, runtimeModelCreationContext);
    }

    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableInsertStrategy(rootEntityDescriptor, runtimeModelCreationContext);
    }

    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.LOCAL;
    }

    public TemporaryTableStrategy getLocalTemporaryTableStrategy() {
        return InformixLocalTemporaryTableStrategy.INSTANCE;
    }

    public String getTemporaryTableCreateOptions() {
        return InformixLocalTemporaryTableStrategy.INSTANCE.getTemporaryTableCreateOptions();
    }

    public String getTemporaryTableCreateCommand() {
        return InformixLocalTemporaryTableStrategy.INSTANCE.getTemporaryTableCreateCommand();
    }

    public AfterUseAction getTemporaryTableAfterUseAction() {
        return InformixLocalTemporaryTableStrategy.INSTANCE.getTemporaryTableAfterUseAction();
    }

    public BeforeUseAction getTemporaryTableBeforeUseAction() {
        return InformixLocalTemporaryTableStrategy.INSTANCE.getTemporaryTableBeforeUseAction();
    }

    public String[] getCreateSchemaCommand(String schemaName) {
        return new String[]{"create schema authorization " + schemaName};
    }

    public String[] getDropSchemaCommand(String schemaName) {
        return new String[]{""};
    }

    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.BOTH;
    }

    public boolean useCrossReferenceForeignKeys() {
        return true;
    }

    public String getCrossReferenceParentTableFilter() {
        return "%";
    }

    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return InformixIdentityColumnSupport.INSTANCE;
    }

    public Exporter<Table> getTableExporter() {
        return this.informixTableExporter;
    }

    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        appender.appendSql("cast(");
        appender.appendSql(bool ? "'t'" : "'f'");
        appender.appendSql(" as boolean)");
    }

    public String currentDate() {
        return "today";
    }

    public String currentTime() {
        return "current hour to fraction";
    }

    public String currentTimestamp() {
        return "current";
    }

    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(InformixDialect.datetimeFormat(format).result());
    }

    public boolean supportsStandardCurrentTimestampFunction() {
        return false;
    }

    public static Replacer datetimeFormat(String format) {
        return new Replacer(format, "'", "").replace("%", "%%").replace("yyyy", "%Y").replace("yyy", "%Y").replace("yy", "%y").replace("y", "Y").replace("MMMM", "%B").replace("MMM", "%b").replace("MM", "%m").replace("M", "%c").replace("EEEE", "%A").replace("EEE", "%a").replace("ee", "%w").replace("e", "%w").replace("dd", "%d").replace("d", "%e").replace("a", "%p").replace("hh", "%I").replace("HH", "%H").replace("h", "%I").replace("H", "%H").replace("mm", "%M").replace("m", "%M").replace("ss", "%S").replace("s", "%S").replace("SSSSSS", "%F50").replace("SSSSS", "%F5").replace("SSSS", "%F4").replace("SSS", "%F3").replace("SS", "%F2").replace("S", "%F1");
    }

    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        appender.append((CharSequence)"datetime (");
        switch (precision) {
            case DATE: {
                DateTimeUtils.appendAsDate((SqlAppender)appender, (TemporalAccessor)temporalAccessor);
                appender.appendSql(") year to day");
                break;
            }
            case TIME: {
                DateTimeUtils.appendAsTime((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)this.supportsTemporalLiteralOffset(), (TimeZone)jdbcTimeZone);
                appender.appendSql(") hour to second");
                break;
            }
            case TIMESTAMP: {
                DateTimeUtils.appendAsTimestampWithMillis((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)this.supportsTemporalLiteralOffset(), (TimeZone)jdbcTimeZone);
                appender.appendSql(") year to fraction");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        appender.append((CharSequence)"datetime (");
        switch (precision) {
            case DATE: {
                DateTimeUtils.appendAsDate((SqlAppender)appender, (Date)date);
                appender.appendSql(") year to day");
                break;
            }
            case TIME: {
                DateTimeUtils.appendAsLocalTime((SqlAppender)appender, (Date)date);
                appender.appendSql(") hour to fraction");
                break;
            }
            case TIMESTAMP: {
                DateTimeUtils.appendAsTimestampWithMillis((SqlAppender)appender, (Date)date, (TimeZone)jdbcTimeZone);
                appender.appendSql(") year to fraction");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public String getSelectClauseNullString(int sqlType, TypeConfiguration typeConfiguration) {
        DdlType descriptor = typeConfiguration.getDdlTypeRegistry().getDescriptor(sqlType);
        String castType = descriptor != null ? InformixDialect.castType(descriptor) : "integer";
        return "cast(null as " + castType + ")";
    }

    private static String castType(DdlType descriptor) {
        String typeName = descriptor.getTypeName(Size.length((long)255L));
        int loc = typeName.indexOf(40);
        return loc < 0 ? typeName : typeName.substring(0, loc);
    }

    public String getNoColumnsInsertString() {
        return "values (0)";
    }

    public boolean supportsNationalizedMethods() {
        return false;
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        jdbcTypeRegistry.addDescriptor(2011, (JdbcType)ClobJdbcType.DEFAULT);
        typeContributions.contributeJdbcType((JdbcType)VarcharUUIDJdbcType.INSTANCE);
        typeContributions.contributeJdbcType((JdbcType)ObjectNullAsBinaryTypeJdbcType.INSTANCE);
        typeContributions.contributeType((BasicType)new JavaObjectType((JdbcType)ObjectNullAsBinaryTypeJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().resolveDescriptor(Object.class)));
    }

    public String getDual() {
        return "(select 0 from systables where tabid=1)";
    }

    public String getFromDualForSelectOnly() {
        return this.getVersion().isBefore(12, 10) ? " from " + this.getDual() + " dual" : "";
    }

    public boolean supportsCrossJoin() {
        return false;
    }

    public boolean supportsIntersect() {
        return this.getVersion().isSameOrAfter(12, 10);
    }

    public boolean supportsSubqueryOnMutatingTable() {
        return this.getVersion().isAfter(11, 50);
    }

    public boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    public boolean supportsWithClause() {
        return this.getVersion().isSameOrAfter(14, 10);
    }

    public boolean requiresColumnListInCreateView() {
        return true;
    }

    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, @Nullable DatabaseMetaData metadata) throws SQLException {
        if (metadata == null) {
            builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.LOWER);
        }
        return super.buildIdentifierHelper(builder, metadata);
    }

    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return this.getVersion().isSameOrAfter(12, 10) ? DmlTargetColumnQualifierSupport.TABLE_ALIAS : DmlTargetColumnQualifierSupport.NONE;
    }
}

