/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.function;

import java.util.List;
import org.hibernate.dialect.function.AbstractRegexpLikeFunction;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.type.spi.TypeConfiguration;

public class InformixRegexpLikeFunction
extends AbstractRegexpLikeFunction {
    public InformixRegexpLikeFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration);
    }

    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        boolean caseSensitive;
        if (arguments.size() > 2) {
            String flags;
            Literal literal;
            Object object = arguments.get(2);
            if (!(object instanceof Literal && (object = (literal = (Literal)object).getLiteralValue()) instanceof String && (flags = (String)object).equals("i"))) {
                throw new IllegalArgumentException("Informix only supports the case insensitive flag 'i' as literal but got.");
            }
            caseSensitive = false;
        } else {
            caseSensitive = true;
        }
        sqlAppender.appendSql("regex_match(");
        arguments.get(0).accept(walker);
        sqlAppender.appendSql(',');
        arguments.get(1).accept(walker);
        if (!caseSensitive) {
            sqlAppender.appendSql(",3");
        }
        sqlAppender.appendSql(')');
    }

    public boolean isPredicate() {
        return false;
    }
}

