/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.annotation;

import java.util.List;
import java.util.StringTokenizer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.jpamodelgen.annotation.AbstractFinderMethod;
import org.hibernate.jpamodelgen.annotation.AbstractQueryMethod;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaEntity;
import org.hibernate.jpamodelgen.util.Constants;
import org.hibernate.jpamodelgen.util.TypeUtils;

public class CriteriaFinderMethod
extends AbstractFinderMethod {
    private final @Nullable @UnknownKeyFor @Initialized String containerType;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> paramNullability;

    public CriteriaFinderMethod(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity, @UnknownKeyFor @NonNull @Initialized String methodName, @UnknownKeyFor @NonNull @Initialized String entity, @Nullable @UnknownKeyFor @Initialized String containerType, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> paramNullability, @UnknownKeyFor @NonNull @Initialized boolean belongsToDao, @UnknownKeyFor @NonNull @Initialized String sessionType, @UnknownKeyFor @NonNull @Initialized String sessionName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fetchProfiles, @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation) {
        super(annotationMetaEntity, methodName, entity, belongsToDao, sessionType, sessionName, fetchProfiles, paramNames, paramTypes, addNonnullAnnotation);
        this.containerType = containerType;
        this.paramNullability = paramNullability;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isNullable(@UnknownKeyFor @NonNull @Initialized int index) {
        return this.paramNullability.get(index);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeDeclarationString() {
        boolean unwrap;
        List<String> paramTypes = this.parameterTypes();
        StringBuilder declaration = new StringBuilder();
        this.comment(declaration);
        this.modifiers(declaration);
        declaration.append((CharSequence)this.returnType()).append(" ").append(this.methodName);
        this.parameters(paramTypes, declaration);
        declaration.append(" {");
        for (int i = 0; i < this.paramNames.size(); ++i) {
            String paramName = (String)this.paramNames.get(i);
            String paramType = paramTypes.get(i);
            if (this.isNullable(i) || TypeUtils.isPrimitive(paramType)) continue;
            declaration.append("\n\tif (").append(paramName).append(" == null) throw new IllegalArgumentException(\"Null \" + ").append(paramName).append(");");
        }
        declaration.append("\n\tvar builder = ").append(this.sessionName).append(this.isUsingEntityManager() ? ".getEntityManagerFactory()" : ".getFactory()").append(".getCriteriaBuilder();").append("\n\tvar query = builder.createQuery(").append(this.annotationMetaEntity.importType(this.entity)).append(".class);").append("\n\tvar entity = query.from(").append(this.annotationMetaEntity.importType(this.entity)).append(".class);").append("\n\tquery.where(");
        boolean first = true;
        for (int i = 0; i < this.paramNames.size(); ++i) {
            String paramName = (String)this.paramNames.get(i);
            String paramType = paramTypes.get(i);
            if (CriteriaFinderMethod.isSessionParameter(paramType) || CriteriaFinderMethod.isPageParam(paramType) || CriteriaFinderMethod.isOrderParam(paramType)) continue;
            if (first) {
                first = false;
            } else {
                declaration.append(", ");
            }
            this.parameter(declaration, i, paramName, paramType);
        }
        declaration.append("\n\t);").append("\n\treturn ").append(this.sessionName).append(".createQuery(query)");
        boolean hasOrderParameter = paramTypes.stream().anyMatch(AbstractQueryMethod::isOrderParam);
        boolean hasEnabledFetchProfiles = !this.fetchProfiles.isEmpty();
        boolean hasNativeReturnType = this.containerType != null && this.containerType.startsWith("org.hibernate");
        boolean bl = unwrap = (hasOrderParameter || hasEnabledFetchProfiles || hasNativeReturnType) && this.isUsingEntityManager();
        if (unwrap) {
            declaration.append("\n\t\t\t.unwrap(").append(this.annotationMetaEntity.importType("org.hibernate.query.SelectionQuery")).append(".class)");
        }
        for (int i = 0; i < this.paramNames.size(); ++i) {
            String paramName = (String)this.paramNames.get(i);
            String paramType = paramTypes.get(i);
            if (CriteriaFinderMethod.isPageParam(paramType)) {
                this.setPage(declaration, paramName);
                continue;
            }
            if (!CriteriaFinderMethod.isOrderParam(paramType)) continue;
            this.setOrder(declaration, true, paramName, paramType);
        }
        this.enableFetchProfile(declaration);
        if (this.containerType == null) {
            if (unwrap || hasEnabledFetchProfiles) {
                declaration.append("\n\t\t\t");
            }
            declaration.append(".getSingleResult()");
        } else if (this.containerType.equals(Constants.LIST)) {
            if (unwrap || hasOrderParameter || hasEnabledFetchProfiles) {
                declaration.append("\n\t\t\t");
            }
            declaration.append(".getResultList()");
        }
        declaration.append(";\n}");
        return declaration.toString();
    }

    private void parameter(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized int i, @UnknownKeyFor @NonNull @Initialized String paramName, @UnknownKeyFor @NonNull @Initialized String paramType) {
        declaration.append("\n\t\t\t");
        if (this.isNullable(i) && !TypeUtils.isPrimitive(paramType)) {
            declaration.append(paramName).append("==null").append("\n\t\t\t\t? ").append("entity");
            this.path(declaration, paramName);
            declaration.append(".isNull()").append("\n\t\t\t\t: ");
        }
        declaration.append("builder.equal(entity");
        this.path(declaration, paramName);
        declaration.append(", ").append(paramName).append(')');
    }

    private void path(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized String paramName) {
        StringTokenizer tokens = new StringTokenizer(paramName, "$");
        String typeName = this.entity;
        while (typeName != null && tokens.hasMoreTokens()) {
            String memberName = tokens.nextToken();
            declaration.append(".get(").append(this.annotationMetaEntity.importType(typeName + "_")).append('.').append(memberName).append(')');
            typeName = this.annotationMetaEntity.getMemberType(typeName, memberName);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized StringBuilder returnType() {
        boolean returnsUni;
        StringBuilder type = new StringBuilder();
        boolean bl = returnsUni = this.isReactive() && (this.containerType == null || Constants.LIST.equals(this.containerType));
        if (returnsUni) {
            type.append(this.annotationMetaEntity.importType("io.smallrye.mutiny.Uni")).append('<');
        }
        if (this.containerType != null) {
            type.append(this.annotationMetaEntity.importType(this.containerType)).append('<');
        }
        type.append(this.annotationMetaEntity.importType(this.entity));
        if (this.containerType != null) {
            type.append('>');
        }
        if (returnsUni) {
            type.append('>');
        }
        return type;
    }
}

