/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.annotation;

import java.util.List;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.jpamodelgen.annotation.AbstractFinderMethod;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaEntity;

public class NaturalIdFinderMethod
extends AbstractFinderMethod {
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> paramNullability;

    public NaturalIdFinderMethod(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity, @UnknownKeyFor @NonNull @Initialized String methodName, @UnknownKeyFor @NonNull @Initialized String entity, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> paramNullability, @UnknownKeyFor @NonNull @Initialized boolean belongsToDao, @UnknownKeyFor @NonNull @Initialized String sessionType, @UnknownKeyFor @NonNull @Initialized String sessionName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fetchProfiles, @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation) {
        super(annotationMetaEntity, methodName, entity, belongsToDao, sessionType, sessionName, fetchProfiles, paramNames, paramTypes, addNonnullAnnotation);
        this.paramNullability = paramNullability;
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized boolean isNullable(@UnknownKeyFor @NonNull @Initialized int index) {
        return this.paramNullability.get(index);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeDeclarationString() {
        StringBuilder declaration = new StringBuilder();
        this.comment(declaration);
        this.preamble(declaration);
        this.unwrapSession(declaration);
        if (this.isReactive()) {
            this.findReactively(declaration);
        } else {
            this.findBlockingly(declaration);
        }
        declaration.append(";\n}");
        return declaration.toString();
    }

    private void findBlockingly(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append(".byNaturalId(").append(this.annotationMetaEntity.importType(this.entity)).append(".class)");
        this.enableFetchProfile(declaration);
        for (int i = 0; i < this.paramNames.size(); ++i) {
            if (NaturalIdFinderMethod.isSessionParameter((String)this.paramTypes.get(i))) continue;
            String paramName = (String)this.paramNames.get(i);
            declaration.append("\n\t\t\t.using(").append(this.annotationMetaEntity.importType(this.entity + "_")).append('.').append(paramName).append(", ").append(paramName).append(")");
        }
        declaration.append("\n\t\t\t.load()");
    }

    private void findReactively(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        boolean composite = this.paramTypes.stream().filter(type -> !NaturalIdFinderMethod.isSessionParameter(type)).count() > 1L;
        declaration.append(".find(");
        if (composite) {
            declaration.append("\n\t\t\t");
        }
        declaration.append(this.annotationMetaEntity.importType(this.entity)).append(".class, ");
        if (composite) {
            declaration.append("\n\t\t\t").append(this.annotationMetaEntity.importType("org.hibernate.reactive.common.Identifier")).append(".composite(");
        }
        boolean first = true;
        for (int i = 0; i < this.paramNames.size(); ++i) {
            if (NaturalIdFinderMethod.isSessionParameter((String)this.paramTypes.get(i))) continue;
            if (first) {
                first = false;
            } else {
                declaration.append(", ");
            }
            if (composite) {
                declaration.append("\n\t\t\t\t");
            }
            String paramName = (String)this.paramNames.get(i);
            declaration.append(this.annotationMetaEntity.importType("org.hibernate.reactive.common.Identifier")).append(".id(").append(this.annotationMetaEntity.importType(this.entity + "_")).append('.').append(paramName).append(", ").append(paramName).append(")");
        }
        if (composite) {
            declaration.append("\n\t\t\t)\n\t");
        }
        declaration.append(")");
    }
}

