
package org.hibernate.processor.xml.jaxb;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * 
 *         @Target({}) @Retention(RUNTIME)
 *         public @interface EntityResult {
 *           Class entityClass();
 *           FieldResult[] fields() default {};
 *           String discriminatorColumn() default "";
 *         }
 * 
 *       
 * 
 * <p>Java class for entity-result complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="entity-result">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="field-result" type="{https://jakarta.ee/xml/ns/persistence/orm}field-result" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="entity-class" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="discriminator-column" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "entity-result", namespace = "https://jakarta.ee/xml/ns/persistence/orm", propOrder = {
    "fieldResult"
})
public class EntityResult {

    @XmlElement(name = "field-result", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<FieldResult> fieldResult;
    @XmlAttribute(name = "entity-class", required = true)
    protected String entityClass;
    @XmlAttribute(name = "discriminator-column")
    protected String discriminatorColumn;

    /**
     * Gets the value of the fieldResult property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the fieldResult property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFieldResult().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FieldResult }
     * 
     * 
     * @return
     *     The value of the fieldResult property.
     */
    public List<FieldResult> getFieldResult() {
        if (fieldResult == null) {
            fieldResult = new ArrayList<>();
        }
        return this.fieldResult;
    }

    /**
     * Gets the value of the entityClass property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getEntityClass() {
        return entityClass;
    }

    /**
     * Sets the value of the entityClass property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setEntityClass(String value) {
        this.entityClass = value;
    }

    /**
     * Gets the value of the discriminatorColumn property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDiscriminatorColumn() {
        return discriminatorColumn;
    }

    /**
     * Sets the value of the discriminatorColumn property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDiscriminatorColumn(String value) {
        this.discriminatorColumn = value;
    }

}
