/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import javax.lang.model.element.Element;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.StringUtil;
import org.hibernate.processor.util.TypeUtils;

public class DataAnnotationMetaAttribute
implements MetaAttribute {
    private final @UnknownKeyFor @NonNull @Initialized Element element;
    private final @UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity parent;
    private final @UnknownKeyFor @NonNull @Initialized String type;
    private final @Nullable @UnknownKeyFor @Initialized String path;

    public DataAnnotationMetaAttribute(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity parent, @UnknownKeyFor @NonNull @Initialized Element element, @UnknownKeyFor @NonNull @Initialized String type, @Nullable @UnknownKeyFor @Initialized String path) {
        this.element = element;
        this.parent = parent;
        this.type = type;
        this.path = path;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasStringAttribute() {
        return true;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isTextual() {
        return String.class.getName().equals(this.type);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeDeclarationString() {
        String className = this.parent.importType(this.parent.getQualifiedName());
        String elementName = this.element.getSimpleName().toString();
        String memberName = this.path == null ? elementName : this.path + "." + elementName;
        String impl = this.isTextual() ? this.parent.importType("jakarta.data.metamodel.impl.TextAttributeRecord") : this.parent.importType("jakarta.data.metamodel.impl.SortableAttributeRecord");
        return "\n/**\n * @see " + className + "#" + memberName + "\n **/\n" + this.parent.importType(this.getMetaType()) + "<" + className + "> " + this.getPropertyName().replace('.', '_') + " = new " + impl + "<>(" + this.fieldName() + ");";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeNameDeclarationString() {
        return this.parent.importType(String.class.getName()) + " " + this.fieldName() + " = " + "\"" + this.getPropertyName() + "\"" + ";";
    }

    private @UnknownKeyFor @NonNull @Initialized String fieldName() {
        return StringUtil.getUpperUnderscoreCaseFromLowerCamelCase(this.getPropertyName().replace('.', '_'));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getPropertyName() {
        String propertyName = TypeUtils.propertyName(this.parent, this.element);
        return this.path == null ? propertyName : this.path + "." + propertyName;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Metamodel getHostingEntity() {
        return this.parent;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getMetaType() {
        return this.isTextual() ? "jakarta.data.metamodel.TextAttribute" : "jakarta.data.metamodel.SortableAttribute";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTypeDeclaration() {
        return this.type;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "DataAnnotationMetaAttribute" + "{element=" + this.element + ", type='" + this.type + '\'' + '}';
    }
}

