/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.PackageElement;
import javax.tools.Diagnostic;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.processor.Context;
import org.hibernate.processor.ImportContextImpl;
import org.hibernate.processor.annotation.AnnotationMeta;
import org.hibernate.processor.model.ImportContext;
import org.hibernate.processor.model.MetaAttribute;

public class AnnotationMetaPackage
extends AnnotationMeta {
    private final @UnknownKeyFor @NonNull @Initialized ImportContext importContext;
    private final @UnknownKeyFor @NonNull @Initialized PackageElement element;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MetaAttribute> members;
    private final @UnknownKeyFor @NonNull @Initialized Context context;
    private @UnknownKeyFor @NonNull @Initialized boolean initialized;

    public AnnotationMetaPackage(@UnknownKeyFor @NonNull @Initialized PackageElement element, @UnknownKeyFor @NonNull @Initialized Context context) {
        this.element = element;
        this.context = context;
        this.members = new HashMap<String, MetaAttribute>();
        this.importContext = new ImportContextImpl(AnnotationMetaPackage.getPackageName(context, element));
    }

    public static @UnknownKeyFor @NonNull @Initialized AnnotationMetaPackage create(@UnknownKeyFor @NonNull @Initialized PackageElement element, @UnknownKeyFor @NonNull @Initialized Context context) {
        return new AnnotationMetaPackage(element, context);
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized Context getContext() {
        return this.context;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isImplementation() {
        return false;
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String getSimpleName() {
        return this.element.getSimpleName().toString();
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String getQualifiedName() {
        return this.element.getQualifiedName().toString();
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized String getSupertypeName() {
        return null;
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String getPackageName() {
        return AnnotationMetaPackage.getPackageName(this.context, this.element);
    }

    private static @UnknownKeyFor @NonNull @Initialized String getPackageName(@UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized PackageElement packageOf) {
        return context.getElementUtils().getName(packageOf.getQualifiedName()).toString();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MetaAttribute> getMembers() {
        if (!this.initialized) {
            this.init();
        }
        return new ArrayList<MetaAttribute>(this.members.values());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isMetaComplete() {
        return false;
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String generateImports() {
        return this.importContext.generateImports();
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String importType(@UnknownKeyFor @NonNull @Initialized String fqcn) {
        return this.importContext.importType(fqcn);
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String staticImport(@UnknownKeyFor @NonNull @Initialized String fqcn, @UnknownKeyFor @NonNull @Initialized String member) {
        return this.importContext.staticImport(fqcn, member);
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized PackageElement getElement() {
        return this.element;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "AnnotationMetaPackage" + "{element=" + this.element + '}';
    }

    protected final void init() {
        this.getContext().logMessage(Diagnostic.Kind.OTHER, "Initializing type " + this.getQualifiedName() + ".");
        this.addAuxiliaryMembers();
        this.checkNamedQueries();
        this.initialized = true;
    }

    @Override
    void putMember(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized MetaAttribute nameMetaAttribute) {
        this.members.put(name, nameMetaAttribute);
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized boolean isRepository() {
        return false;
    }

    @Override
    @Nullable @UnknownKeyFor @Initialized String getSessionType() {
        return null;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isInjectable() {
        return false;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String scope() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isJakartaDataStyle() {
        return false;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AnnotationMirror> inheritedAnnotations() {
        return Collections.emptyList();
    }
}

