/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.query.sqm.function.NamedSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.spatial.CommonSpatialFunction;
import org.hibernate.spatial.FunctionKey;
import org.hibernate.spatial.KeyedSqmFunctionDescriptors;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;

public class BaseSqmFunctionDescriptors
implements KeyedSqmFunctionDescriptors {
    protected final Map<FunctionKey, SqmFunctionDescriptor> map = new HashMap<FunctionKey, SqmFunctionDescriptor>();

    public BaseSqmFunctionDescriptors(FunctionContributions functionContributions) {
        BasicTypeRegistry basicTypeRegistry = functionContributions.getTypeConfiguration().getBasicTypeRegistry();
        for (CommonSpatialFunction func : this.filter(CommonSpatialFunction.values())) {
            FunctionReturnTypeResolver returnTypeResolver = func.getReturnType() == null ? StandardFunctionReturnTypeResolvers.useFirstNonNull() : StandardFunctionReturnTypeResolvers.invariant((BasicType)basicTypeRegistry.resolve(func.getReturnType()));
            this.map.put(func.getKey(), (SqmFunctionDescriptor)new NamedSqmFunctionDescriptor(func.getKey().getName(), true, StandardArgumentsValidators.exactly((int)func.getNumArgs()), returnTypeResolver));
        }
    }

    public CommonSpatialFunction[] filter(CommonSpatialFunction[] functions) {
        return functions;
    }

    @Override
    public Map<FunctionKey, SqmFunctionDescriptor> asMap() {
        return Collections.unmodifiableMap(this.map);
    }
}

