/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.bytecode.enhancement.extension;

import java.lang.reflect.AnnotatedElement;
import org.hibernate.testing.bytecode.enhancement.extension.BytecodeEnhanced;
import org.hibernate.testing.bytecode.enhancement.extension.engine.BytecodeEnhancedEngineDescriptor;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.launcher.PostDiscoveryFilter;

public class BytecodeEnhancementPostDiscoveryFilter
implements PostDiscoveryFilter {
    public FilterResult apply(TestDescriptor testDescriptor) {
        if (testDescriptor instanceof ClassBasedTestDescriptor) {
            ClassBasedTestDescriptor descriptor = (ClassBasedTestDescriptor)testDescriptor;
            TestDescriptor root = testDescriptor;
            while (!root.isRoot()) {
                root = (TestDescriptor)root.getParent().get();
            }
            boolean isEnhanced = AnnotationUtils.isAnnotated((AnnotatedElement)descriptor.getTestClass(), BytecodeEnhanced.class);
            if (root instanceof BytecodeEnhancedEngineDescriptor) {
                if (!isEnhanced) {
                    return FilterResult.excluded((String)"Not bytecode enhanced.");
                }
            } else if (isEnhanced) {
                testDescriptor.removeFromHierarchy();
                return FilterResult.excluded((String)"Not bytecode enhanced.");
            }
        }
        return FilterResult.included((String)"Ok.");
    }
}

