/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.jdbc.leak;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.testing.jdbc.leak.IdleConnectionCounter;

public class PostgreSQLIdleConnectionCounter
implements IdleConnectionCounter {
    public static final IdleConnectionCounter INSTANCE = new PostgreSQLIdleConnectionCounter();

    @Override
    public boolean appliesTo(Class<? extends Dialect> dialect) {
        return PostgreSQLDialect.class.isAssignableFrom(dialect);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int count(Connection connection) {
        try (Statement statement = connection.createStatement();){
            int n;
            block18: {
                ResultSet resultSet;
                block16: {
                    int n2;
                    block17: {
                        resultSet = statement.executeQuery("select count(*) from pg_stat_activity where state ilike '%idle%'");
                        try {
                            if (!resultSet.next()) break block16;
                            n2 = resultSet.getInt(1);
                            if (resultSet == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return n2;
                }
                n = 0;
                if (resultSet == null) break block18;
                resultSet.close();
            }
            return n;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }
}

