/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import org.hibernate.testing.orm.junit.EntityManagerFactoryExtension;
import org.hibernate.testing.orm.junit.JUnitHelper;
import org.hibernate.testing.orm.junit.LoggingInspections;
import org.hibernate.testing.orm.junit.LoggingInspectionsScope;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public class LoggingInspectionsExtension
implements TestInstancePostProcessor,
BeforeEachCallback {
    private static final String KEY = LoggingInspectionsExtension.class.getName();

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        LoggingInspectionsExtension.resolveLoggingInspectionScope(testInstance, context);
    }

    public void beforeEach(ExtensionContext context) {
        ExtensionContext.Store extensionStore = LoggingInspectionsExtension.locateExtensionStore(context.getRequiredTestInstance(), context);
        LoggingInspectionsScope existing = (LoggingInspectionsScope)extensionStore.get((Object)KEY);
        if (existing != null) {
            existing.resetWatchers();
        }
    }

    public static LoggingInspectionsScope resolveLoggingInspectionScope(Object testInstance, ExtensionContext context) {
        ExtensionContext.Store extensionStore = LoggingInspectionsExtension.locateExtensionStore(testInstance, context);
        Object existing = extensionStore.get((Object)KEY);
        if (existing != null) {
            return (LoggingInspectionsScope)existing;
        }
        LoggingInspections loggingInspections = testInstance.getClass().getAnnotation(LoggingInspections.class);
        LoggingInspectionsScope scope = new LoggingInspectionsScope(loggingInspections, context);
        extensionStore.put((Object)KEY, (Object)scope);
        return scope;
    }

    private static ExtensionContext.Store locateExtensionStore(Object testInstance, ExtensionContext context) {
        return JUnitHelper.locateExtensionStore(EntityManagerFactoryExtension.class, context, testInstance);
    }
}

