/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import java.lang.reflect.Method;
import org.hibernate.testing.orm.junit.LoggingInspectionsExtension;
import org.hibernate.testing.orm.junit.MessageKeyInspection;
import org.hibernate.testing.orm.junit.MessageKeyWatcher;
import org.hibernate.testing.orm.junit.MessageKeyWatcherImpl;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public class MessageKeyInspectionExtension
implements TestInstancePostProcessor,
BeforeEachCallback {
    public static final String KEY = LoggingInspectionsExtension.class.getName();

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        ExtensionContext.Store instanceStore = MessageKeyInspectionExtension.resolveInstanceStore(testInstance, context);
        Object existing = instanceStore.get((Object)KEY);
        if (existing != null) {
            return;
        }
        MessageKeyInspection inspection = testInstance.getClass().getAnnotation(MessageKeyInspection.class);
        MessageKeyWatcherImpl watcher = new MessageKeyWatcherImpl(inspection.messageKey());
        watcher.addLogger(inspection.logger());
        instanceStore.put((Object)KEY, (Object)watcher);
    }

    public static ExtensionContext.Store resolveInstanceStore(Object testInstance, ExtensionContext context) {
        ExtensionContext.Namespace instanceStoreNamespace = ExtensionContext.Namespace.create((Object[])new Object[]{testInstance});
        return context.getStore(instanceStoreNamespace);
    }

    public void beforeEach(ExtensionContext context) {
        Method method = context.getRequiredTestMethod();
        ExtensionContext.Store methodStore = MessageKeyInspectionExtension.resolveMethodStore(context);
        MessageKeyWatcher existing = (MessageKeyWatcher)methodStore.get((Object)KEY);
        if (existing != null) {
            this.prepareForUse(existing);
            return;
        }
        MessageKeyInspection inspectionAnn = method.getAnnotation(MessageKeyInspection.class);
        if (inspectionAnn != null) {
            MessageKeyWatcherImpl watcher = new MessageKeyWatcherImpl(inspectionAnn.messageKey());
            watcher.addLogger(inspectionAnn.logger());
            methodStore.put((Object)KEY, (Object)watcher);
            this.prepareForUse(watcher);
            return;
        }
        ExtensionContext.Store instanceStore = MessageKeyInspectionExtension.resolveInstanceStore(context.getRequiredTestInstance(), context);
        MessageKeyWatcher instanceLevelWatcher = (MessageKeyWatcher)instanceStore.get((Object)KEY);
        if (instanceLevelWatcher != null) {
            methodStore.put((Object)KEY, (Object)instanceLevelWatcher);
            this.prepareForUse(instanceLevelWatcher);
        }
    }

    private void prepareForUse(MessageKeyWatcher watcher) {
        watcher.reset();
    }

    public static ExtensionContext.Store resolveMethodStore(ExtensionContext context) {
        ExtensionContext.Namespace instanceStoreNamespace = ExtensionContext.Namespace.create((Object[])new Object[]{context.getRequiredTestMethod()});
        return context.getStore(instanceStoreNamespace);
    }

    public static MessageKeyWatcher getWatcher(ExtensionContext context) {
        ExtensionContext.Store methodStore = MessageKeyInspectionExtension.resolveMethodStore(context);
        Object ref = methodStore.get((Object)KEY);
        if (ref == null) {
            throw new IllegalStateException("No watcher available");
        }
        return (MessageKeyWatcher)ref;
    }
}

