/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.util;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.internal.StandardServiceRegistryImpl;
import org.hibernate.cfg.Environment;
import org.hibernate.testing.jdbc.SharedDriverManagerConnectionProviderImpl;

public class ServiceRegistryUtil {
    public static StandardServiceRegistryBuilder serviceRegistryBuilder() {
        return ServiceRegistryUtil.applySettings(new StandardServiceRegistryBuilder());
    }

    public static StandardServiceRegistryBuilder serviceRegistryBuilder(BootstrapServiceRegistry bsr) {
        return ServiceRegistryUtil.applySettings(new StandardServiceRegistryBuilder(bsr));
    }

    public static StandardServiceRegistryImpl serviceRegistry() {
        return (StandardServiceRegistryImpl)ServiceRegistryUtil.serviceRegistryBuilder().build();
    }

    public static StandardServiceRegistryBuilder applySettings(StandardServiceRegistryBuilder builder) {
        if (!Environment.getProperties().containsKey("hibernate.connection.provider_class") && !builder.getSettings().containsKey("hibernate.connection.provider_class")) {
            builder.applySetting("hibernate.connection.provider_class", (Object)SharedDriverManagerConnectionProviderImpl.getInstance());
            builder.applySetting("hibernate.connection.provider_disables_autocommit", (Object)Boolean.TRUE);
        }
        return builder;
    }

    public static void applySettings(Map<?, ?> properties) {
        if (!properties.containsKey("hibernate.connection.provider_class")) {
            properties.put("hibernate.connection.provider_class", SharedDriverManagerConnectionProviderImpl.getInstance());
            properties.put("hibernate.connection.provider_disables_autocommit", Boolean.TRUE);
        }
    }

    public static Map<String, Object> createBaseSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        ServiceRegistryUtil.applySettings(settings);
        return settings;
    }
}

