/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.LockOptions;
import org.hibernate.TransientObjectException;
import org.hibernate.TransientPropertyValueException;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.DeleteContext;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.MergeContext;
import org.hibernate.event.spi.PersistContext;
import org.hibernate.event.spi.RefreshContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.reactive.engine.impl.CascadingAction;
import org.hibernate.reactive.engine.impl.ForeignKeys;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class CascadingActions {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    public static final CascadingAction<DeleteContext> REMOVE = new BaseCascadingAction<DeleteContext>(org.hibernate.engine.spi.CascadingActions.REMOVE){

        @Override
        public CompletionStage<Void> cascade(EventSource session, Object child, String entityName, DeleteContext context, boolean isCascadeDeleteEnabled) {
            LOG.tracev("Cascading to delete: {0}", entityName);
            ReactiveSession reactiveSession = (ReactiveSession)session.unwrap(ReactiveSession.class);
            return reactiveSession.reactiveFetch(child, true).thenCompose(c -> reactiveSession.reactiveRemove(entityName, c, isCascadeDeleteEnabled, context));
        }
    };
    public static final CascadingAction<PersistContext> PERSIST = new BaseCascadingAction<PersistContext>(org.hibernate.engine.spi.CascadingActions.PERSIST){

        @Override
        public CompletionStage<Void> cascade(EventSource session, Object child, String entityName, PersistContext context, boolean isCascadeDeleteEnabled) throws HibernateException {
            LOG.tracev("Cascading to persist: {0}", entityName);
            return ((ReactiveSession)session.unwrap(ReactiveSession.class)).reactivePersist(child, context);
        }
    };
    public static final CascadingAction<PersistContext> PERSIST_ON_FLUSH = new BaseCascadingAction<PersistContext>(org.hibernate.engine.spi.CascadingActions.PERSIST_ON_FLUSH){

        @Override
        public CompletionStage<Void> cascade(EventSource session, Object child, String entityName, PersistContext context, boolean isCascadeDeleteEnabled) throws HibernateException {
            LOG.tracev("Cascading to persist on flush: {0}", entityName);
            return ((ReactiveSession)session.unwrap(ReactiveSession.class)).reactivePersistOnFlush(child, context);
        }

        private boolean isInManagedState(Object child, EventSource session) {
            EntityEntry entry = session.getPersistenceContextInternal().getEntry(child);
            if (entry == null) {
                return false;
            }
            switch (entry.getStatus()) {
                case MANAGED: 
                case READ_ONLY: 
                case SAVING: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public CompletionStage<Void> noCascade(EventSource session, Object parent, EntityPersister persister, Type propertyType, int propertyIndex) {
            Object child;
            if (propertyType.isEntityType() && (child = persister.getValue(parent, propertyIndex)) != null && !this.isInManagedState(child, session) && !ManagedTypeHelper.isHibernateProxy((Object)child)) {
                String childEntityName = ((EntityType)propertyType).getAssociatedEntityName(session.getFactory());
                return ForeignKeys.isTransient(childEntityName, child, null, (SessionImplementor)session).thenAccept(isTrans -> {
                    if (isTrans.booleanValue()) {
                        String parentEntityName = persister.getEntityName();
                        String propertyName = persister.getPropertyNames()[propertyIndex];
                        throw new TransientPropertyValueException("object references an unsaved transient instance - save the transient instance before flushing", childEntityName, parentEntityName, propertyName);
                    }
                });
            }
            return CompletionStages.voidFuture();
        }
    };
    @Internal
    public static final CascadingAction<Void> CHECK_ON_FLUSH = new BaseCascadingAction<Void>(org.hibernate.engine.spi.CascadingActions.CHECK_ON_FLUSH){

        @Override
        public CompletionStage<Void> cascade(EventSource session, Object child, String entityName, Void context, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (child != null) {
                return CascadingActions.isChildTransient(session, child, entityName).thenCompose(isTransient -> {
                    if (isTransient.booleanValue()) {
                        return CompletionStages.failedFuture((Throwable)new TransientObjectException("persistent instance references an unsaved transient instance of '" + entityName + "' (save the transient instance before flushing)"));
                    }
                    return CompletionStages.voidFuture();
                });
            }
            return CompletionStages.voidFuture();
        }
    };
    public static final CascadingAction<MergeContext> MERGE = new BaseCascadingAction<MergeContext>(org.hibernate.engine.spi.CascadingActions.MERGE){

        @Override
        public CompletionStage<Void> cascade(EventSource session, Object child, String entityName, MergeContext context, boolean isCascadeDeleteEnabled) throws HibernateException {
            LOG.tracev("Cascading to refresh: {0}", entityName);
            return ((ReactiveSession)session.unwrap(ReactiveSession.class)).reactiveMerge(child, context);
        }
    };
    public static final CascadingAction<RefreshContext> REFRESH = new BaseCascadingAction<RefreshContext>(org.hibernate.engine.spi.CascadingActions.REFRESH){

        @Override
        public CompletionStage<Void> cascade(EventSource session, Object child, String entityName, RefreshContext context, boolean isCascadeDeleteEnabled) throws HibernateException {
            LOG.tracev("Cascading to refresh: {0}", entityName);
            return ((ReactiveSession)session.unwrap(ReactiveSession.class)).reactiveRefresh(child, context);
        }
    };
    public static final CascadingAction<LockOptions> LOCK = new BaseCascadingAction<LockOptions>(org.hibernate.engine.spi.CascadingActions.LOCK){

        @Override
        public CompletionStage<Void> cascade(EventSource session, Object child, String entityName, LockOptions context, boolean isCascadeDeleteEnabled) throws HibernateException {
            LOG.tracev("Cascading to lock: {0}", entityName);
            return ((ReactiveSession)session.unwrap(ReactiveSession.class)).reactiveLock(child, context);
        }
    };

    private CascadingActions() {
    }

    private static CompletionStage<Boolean> isChildTransient(EventSource session, Object child, String entityName) {
        if (ManagedTypeHelper.isHibernateProxy((Object)child)) {
            return CompletionStages.falseFuture();
        }
        EntityEntry entry = session.getPersistenceContextInternal().getEntry(child);
        if (entry != null) {
            boolean deleted = entry.getStatus().isDeletedOrGone();
            return CompletionStages.completedFuture(deleted);
        }
        return ForeignKeys.isTransient(entityName, child, null, (SessionImplementor)session);
    }

    public static abstract class BaseCascadingAction<C>
    implements CascadingAction<C> {
        private final org.hibernate.engine.spi.CascadingAction<C> delegate;

        BaseCascadingAction(org.hibernate.engine.spi.CascadingAction<C> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Iterator<?> getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return this.delegate.getCascadableChildrenIterator(session, collectionType, collection);
        }

        @Override
        public boolean deleteOrphans() {
            return this.delegate.deleteOrphans();
        }

        @Override
        public org.hibernate.engine.spi.CascadingAction<C> delegate() {
            return this.delegate;
        }

        @Override
        public CompletionStage<Void> noCascade(EventSource session, Object parent, EntityPersister persister, Type propertyType, int propertyIndex) {
            return CompletionStages.voidFuture();
        }

        @Override
        public boolean performOnLazyProperty() {
            return this.delegate.performOnLazyProperty();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

