/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.hibernate.TransientObjectException;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.internal.NonNullableTransientDependencies;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.reactive.engine.impl.ReactivePersistenceContextAdapter;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public final class ForeignKeys {
    public static CompletionStage<Boolean> isNotTransient(String entityName, Object entity, Boolean assumed, SessionImplementor session) {
        if (ManagedTypeHelper.isHibernateProxy((Object)entity)) {
            return CompletionStages.trueFuture();
        }
        if (session.getPersistenceContextInternal().isEntryFor(entity)) {
            return CompletionStages.trueFuture();
        }
        return ForeignKeys.isTransient(entityName, entity, assumed, session).thenApply(trans -> trans == false);
    }

    public static CompletionStage<Boolean> isTransient(String entityName, Object entity, Boolean assumed, SessionImplementor session) {
        if (entity == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
            return CompletionStages.falseFuture();
        }
        Boolean isUnsaved = session.getInterceptor().isTransient(entity);
        if (isUnsaved != null) {
            return CompletionStages.completedFuture(isUnsaved);
        }
        EntityPersister persister = session.getEntityPersister(entityName, entity);
        isUnsaved = persister.isTransient(entity, (SharedSessionContractImplementor)session);
        if (isUnsaved != null) {
            return CompletionStages.completedFuture(isUnsaved);
        }
        if (assumed != null) {
            return CompletionStages.completedFuture(assumed);
        }
        ReactivePersistenceContextAdapter persistenceContext = (ReactivePersistenceContextAdapter)session.getPersistenceContextInternal();
        Object id = persister.getIdentifier(entity, (SharedSessionContractImplementor)session);
        return persistenceContext.reactiveGetDatabaseSnapshot(id, persister).thenApply(Objects::isNull);
    }

    public static CompletionStage<Object> getEntityIdentifierIfNotUnsaved(String entityName, Object object, SessionImplementor session) throws TransientObjectException {
        if (object == null) {
            return CompletionStages.nullFuture();
        }
        Object id = session.getContextEntityIdentifier(object);
        if (id == null) {
            return ForeignKeys.isTransient(entityName, object, Boolean.FALSE, session).thenApply(trans -> {
                if (trans.booleanValue()) {
                    throw new TransientObjectException("object references an unsaved transient instance - save the transient instance before flushing: " + (entityName == null ? session.guessEntityName(object) : entityName));
                }
                return session.getEntityPersister(entityName, object).getIdentifier(object, (SharedSessionContractImplementor)session);
            });
        }
        return CompletionStages.completedFuture(id);
    }

    public static CompletionStage<NonNullableTransientDependencies> findNonNullableTransientEntities(String entityName, Object entity, Object[] values, boolean isEarlyInsert, SharedSessionContractImplementor session) {
        EntityPersister persister = session.getEntityPersister(entityName, entity);
        Type[] types = persister.getPropertyTypes();
        Nullifier nullifier = new Nullifier(entity, false, isEarlyInsert, (SessionImplementor)session, persister);
        String[] propertyNames = persister.getPropertyNames();
        boolean[] nullability = persister.getPropertyNullability();
        NonNullableTransientDependencies nonNullableTransientEntities = new NonNullableTransientDependencies();
        return CompletionStages.loop(0, types.length, i -> ForeignKeys.collectNonNullableTransientEntities(nullifier, values[i], propertyNames[i], types[i], nullability[i], session, nonNullableTransientEntities)).thenApply(r -> nonNullableTransientEntities.isEmpty() ? null : nonNullableTransientEntities);
    }

    private static CompletionStage<Void> collectNonNullableTransientEntities(Nullifier nullifier, Object value, String propertyName, Type type, boolean isNullable, SharedSessionContractImplementor session, NonNullableTransientDependencies nonNullableTransientEntities) {
        CompositeType compositeType;
        boolean[] subValueNullability;
        if (value == null) {
            return CompletionStages.voidFuture();
        }
        if (type.isEntityType()) {
            EntityType entityType = (EntityType)type;
            if (!isNullable && !entityType.isOneToOne()) {
                return nullifier.isNullifiable(entityType.getAssociatedEntityName(), value).thenAccept(nullifiable -> {
                    if (nullifiable.booleanValue()) {
                        nonNullableTransientEntities.add(propertyName, value);
                    }
                });
            }
        } else if (type.isAnyType()) {
            if (!isNullable) {
                return nullifier.isNullifiable(null, value).thenAccept(nullifiable -> {
                    if (nullifiable.booleanValue()) {
                        nonNullableTransientEntities.add(propertyName, value);
                    }
                });
            }
        } else if (type.isComponentType() && (subValueNullability = (compositeType = (CompositeType)type).getPropertyNullability()) != null) {
            String[] subPropertyNames = compositeType.getPropertyNames();
            Object[] subvalues = compositeType.getPropertyValues(value, session);
            Type[] subtypes = compositeType.getSubtypes();
            return CompletionStages.loop(0, subtypes.length, i -> ForeignKeys.collectNonNullableTransientEntities(nullifier, subvalues[i], subPropertyNames[i], subtypes[i], subValueNullability[i], session, nonNullableTransientEntities));
        }
        return CompletionStages.voidFuture();
    }

    private ForeignKeys() {
    }

    public static class Nullifier {
        private final boolean isDelete;
        private final boolean isEarlyInsert;
        private final SessionImplementor session;
        private final Object self;
        private final EntityPersister persister;

        public Nullifier(Object self, boolean isDelete, boolean isEarlyInsert, SessionImplementor session, EntityPersister persister) {
            this.isDelete = isDelete;
            this.isEarlyInsert = isEarlyInsert;
            this.session = session;
            this.persister = persister;
            this.self = self;
        }

        public CompletionStage<Void> nullifyTransientReferences(Object[] values) {
            String[] propertyNames = this.persister.getPropertyNames();
            Type[] types = this.persister.getPropertyTypes();
            CompletionStage<Void> loop = CompletionStages.voidFuture();
            int i = 0;
            while (i < values.length) {
                int index = i++;
                loop = loop.thenCompose(v -> this.nullifyTransientReferences(values[index], propertyNames[index], types[index])).thenAccept(replacement -> {
                    values[index] = replacement;
                });
            }
            return loop;
        }

        private CompletionStage<Object> nullifyTransientReferences(Object value, String propertyName, Type type) {
            CompletionStage<Object> returnedStage;
            if (value == null) {
                returnedStage = CompletionStages.nullFuture();
            } else if (type.isEntityType()) {
                EntityType entityType = (EntityType)type;
                returnedStage = entityType.isOneToOne() ? CompletionStages.completedFuture(value) : (this.needToInitialize(value, (Type)entityType) ? ((ReactiveEntityPersister)this.persister).reactiveInitializeLazyProperty(propertyName, this.self, (SharedSessionContractImplementor)this.session).thenCompose(possiblyInitializedValue -> {
                    if (possiblyInitializedValue == null) {
                        return CompletionStages.nullFuture();
                    }
                    return this.isNullifiable(entityType.getAssociatedEntityName(), value).thenApply(trans -> trans != false ? null : value);
                }) : this.isNullifiable(entityType.getAssociatedEntityName(), value).thenApply(trans -> trans != false ? null : value));
            } else if (type.isAnyType()) {
                returnedStage = this.isNullifiable(null, value).thenApply(trans -> trans != false ? null : value);
            } else if (type.isComponentType()) {
                CompositeType compositeType = (CompositeType)type;
                Object[] subValues = compositeType.getPropertyValues(value, (SharedSessionContractImplementor)this.session);
                Type[] subtypes = compositeType.getSubtypes();
                String[] subPropertyNames = compositeType.getPropertyNames();
                CompletionStage<Boolean> loop = CompletionStages.falseFuture();
                int i = 0;
                while (i < subValues.length) {
                    int index = i++;
                    loop = loop.thenCompose(substitute -> this.nullifyTransientReferences(subValues[index], StringHelper.qualify((String)propertyName, (String)subPropertyNames[index]), subtypes[index]).thenApply(replacement -> {
                        if (replacement != subValues[index]) {
                            subValues[index] = replacement;
                            return true;
                        }
                        return substitute;
                    }));
                }
                returnedStage = loop.thenApply(substitute -> {
                    if (substitute.booleanValue()) {
                        compositeType.setPropertyValues(value, subValues);
                    }
                    return value;
                });
            } else {
                returnedStage = CompletionStages.completedFuture(value);
            }
            return returnedStage.thenApply(returnedValue -> {
                if (value != returnedValue && returnedValue == null) {
                    ManagedTypeHelper.processIfSelfDirtinessTracker((Object)this.self, SelfDirtinessTracker::$$_hibernate_trackChange, (Object)propertyName);
                }
                return returnedValue;
            });
        }

        private boolean needToInitialize(Object value, Type type) {
            return this.isDelete && value == LazyPropertyInitializer.UNFETCHED_PROPERTY && type.isEntityType() && !this.session.getPersistenceContextInternal().isNullifiableEntityKeysEmpty();
        }

        private CompletionStage<Boolean> isNullifiable(String entityName, Object object) {
            if (object == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
                return CompletionStages.falseFuture();
            }
            PersistenceContext persistenceContext = this.session.getPersistenceContextInternal();
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer((Object)object);
            if (lazyInitializer != null) {
                Object entity = lazyInitializer.getImplementation((SharedSessionContractImplementor)this.session);
                if (entity == null) {
                    return CompletionStages.completedFuture(persistenceContext.containsDeletedUnloadedEntityKey(this.session.generateEntityKey(lazyInitializer.getIdentifier(), this.session.getFactory().getMappingMetamodel().getEntityDescriptor(lazyInitializer.getEntityName()))));
                }
                object = entity;
            }
            if (object == this.self) {
                return CompletionStages.completedFuture(this.isEarlyInsert || this.isDelete && this.session.getJdbcServices().getDialect().hasSelfReferentialForeignKeyBug());
            }
            EntityEntry entityEntry = persistenceContext.getEntry(object);
            return entityEntry == null ? ForeignKeys.isTransient(entityName, object, null, this.session) : CompletionStages.completedFuture(entityEntry.isNullifiable(this.isEarlyInsert, (SharedSessionContractImplementor)this.session));
        }
    }
}

